/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import org.infinispan.CacheException;
import org.infinispan.cacheviews.CacheView;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.loaders.decorators.SingletonStore;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferException;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransaction;
import org.infinispan.util.TypedProperties;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;
import org.jgroups.View;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to load %s from cache loader", id=1)
    public void unableToLoadFromCacheLoader(Object var1, @Cause CacheLoaderException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Field %s not found!!", id=2)
    public void fieldNotFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Property %s could not be replaced as intended!", id=3)
    public void propertyCouldNotBeReplaced(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unexpected error reading properties", id=4)
    public void errorReadingProperties(@Cause IOException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Detected write skew on key [%s]. Another process has changed the entry since we last read it! Unable to copy entry for update.", id=5)
    public void unableToCopyEntryForUpdate(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed remote execution on node %s", id=6)
    public void remoteExecutionFailed(Address var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed local execution ", id=7)
    public void localExecutionFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Can not select %s random members for %s", id=8)
    public void cannotSelectRandomMembers(int var1, List<Address> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Detected a view change. Member list changed from %s to %s", id=9)
    public void viewChangeDetected(List<Address> var1, List<Address> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="This is a JOIN event! Wait for notification from new joiner %s", id=10)
    public void joinEvent(Address var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="This is a LEAVE event! Node %s has just left", id=11)
    public void leaveEvent(Address var1);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(value="Unable to process leaver!!", id=12)
    public void unableToProcessLeaver(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="I %s am participating in rehash, state providers %s, state receivers %s", id=13)
    public void participatingInRehash(Address var1, List<Address> var2, List<Address> var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="DistributionManager not yet joined the cluster. Cannot do anything about other concurrent joiners.", id=14)
    public void distributionManagerNotJoined();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="DistributionManager not started after waiting up to 5 minutes! Not rehashing!", id=15)
    public void distributionManagerNotStarted();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problem %s encountered when applying state for key %s!", id=16)
    public void problemApplyingStateForKey(String var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="View change interrupted; not rehashing!", id=17)
    public void viewChangeInterrupted();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to apply prepare %s", id=18)
    public void unableToApplyPrepare(PrepareCommand var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Couldn't acquire shared lock", id=19)
    public void couldNotAcquireSharedLock();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Caught exception replaying %s", id=20)
    public void exceptionWhenReplaying(WriteCommand var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Expected just one response; got %s", id=21)
    public void expectedJustOneResponse(Map<Address, Response> var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Completed leave rehash on node %s in %s - leavers now are %s", id=22)
    public void completedLeaveRehash(Address var1, String var2, List<Address> var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error pushing tx log", id=23)
    public void errorPushingTxLog(@Cause ExecutionException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to stop transaction logging!", id=24)
    public void unableToStopTransactionLogging(@Cause IllegalMonitorStateException var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="wakeUpInterval is <= 0, not starting expired purge thread", id=25)
    public void notStartingEvictionThread();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Caught exception purging data container!", id=26)
    public void exceptionPurgingDataContainer(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not acquire lock for eviction of %s", id=27)
    public void couldNotAcquireLockForEviction(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to passivate entry under %s", id=28)
    public void unableToPassivateEntry(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Passivating all entries to disk", id=29)
    public void passivatingAllEntries();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Passivated %d entries in %s", id=30)
    public void passivatedEntries(int var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="MBeans were successfully registered to the platform mbean server.", id=31)
    public void mbeansSuccessfullyRegistered();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problems un-registering MBeans", id=32)
    public void problemsUnregisteringMBeans(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to unregister Cache MBeans with pattern %s", id=33)
    public void unableToUnregisterMBeanWithPattern(String var1, @Cause MBeanRegistrationException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="There's already an cache manager instance registered under '%s' JMX domain. If you want to allow multiple instances configured with same JMX domain enable 'allowDuplicateDomains' attribute in 'globalJmxStatistics' config element", id=34)
    public void cacheManagerAlreadyRegistered(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not reflect field description of this class. Was it removed?", id=35)
    public void couldNotFindDescriptionField();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Did not find attribute %s", id=36)
    public void couldNotFindAttribute(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to update attribute name %s with value %s", id=37)
    public void failedToUpdateAtribute(String var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Method name %s doesn't start with \"get\", \"set\", or \"is\" but is annotated with @ManagedAttribute: will be ignored", id=38)
    public void ignoringManagedAttribute(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Method %s must have a valid return type and zero parameters", id=39)
    public void invalidManagedAttributeMethod(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Not adding annotated method %s since we already have read attribute", id=40)
    public void readManagedAttributeAlreadyPresent(Method var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Not adding annotated method %s since we already have writable attribute", id=41)
    public void writeManagedAttributeAlreadyPresent(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Did not find queried attribute with name %s", id=42)
    public void queriedAttributeNotFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception while writing value for attribute %s", id=43)
    public void errorWritingValueForAttribute(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not invoke set on attribute %s with value %s", id=44)
    public void couldNotInvokeSetOnAttribute(String var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Problems encountered while purging expired", id=45)
    public void problemPurgingExpired(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unknown responses from remote cache: %s", id=46)
    public void unknownResponsesFromRemoteCache(Collection<Response> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while doing remote call", id=47)
    public void errorDoingRemoteCall(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Interrupted or timeout while waiting for AsyncStore worker threads to push all state to the decorated store", id=48)
    public void interruptedWaitingAsyncStorePush(@Cause InterruptedException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error performing clear in async store", id=49)
    public void errorClearinAsyncStore(@Cause CacheLoaderException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error performing purging expired from async store", id=50)
    public void errorPurgingAsyncStore(@Cause CacheLoaderException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error", id=51)
    public void unexpectedErrorInAsyncProcessor(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Interrupted on acquireLock for %d milliseconds!", id=52)
    public void interruptedAcquiringLock(long var1, @Cause InterruptedException var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to process some async modifications after %d retries!", id=53)
    public void unableToProcessAsyncModifications(int var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="AsyncStoreCoordinator interrupted", id=54)
    public void asyncStoreCoordinatorInterrupted(@Cause InterruptedException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error in AsyncStoreCoordinator thread. AsyncStore is dead!", id=55)
    public void unexpectedErrorInAsyncStoreCoordinator(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while handling Modification in AsyncStore", id=56)
    public void errorModifyingAsyncStore(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Clear() operation in async store could not be performed", id=57)
    public void unableToClearAsyncStore();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception reported changing cache active status", id=58)
    public void errorChangingSingletonStoreStatus(@Cause SingletonStore.PushStateException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Had problems removing file %s", id=59)
    public void problemsRemovingFile(File var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problems purging file %s", id=60)
    public void problemsPurgingFile(File var1, @Cause CacheLoaderException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to acquire global lock to purge cache store", id=61)
    public void unableToAcquireLockToPurgeStore();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while reading from file: %s", id=62)
    public void errorReadingFromFile(File var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception while saving bucket %s", id=63)
    public void errorSavingBucket(Bucket var1, @Cause IOException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problems creating the directory: %s", id=64)
    public void problemsCreatingDirectory(File var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception while marshalling object", id=65)
    public void errorMarshallingObject(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to read version id from first two bytes of stream, barfing.", id=66)
    public void unableToReadVersionId();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Will try and wait for the cache %s to start", id=67)
    public void waitForCacheToStart(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Cache named %s does not exist on this cache manager!", id=68)
    public void namedCacheDoesNotExist(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Cache named [%s] exists but isn't in a state to handle remote invocations", id=69)
    public void cacheCanNotHandleInvocations(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Quietly ignoring clustered get call %s since unable to acquire processing lock, even after %s", id=70)
    public void ignoreClusterGetCall(CacheRpcCommand var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Caught exception when handling command %s", id=71)
    public void exceptionHandlingCommand(CacheRpcCommand var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed replicating %d elements in replication queue", id=72)
    public void failedReplicatingQueue(int var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error while replicating", id=73)
    public void unexpectedErrorReplicating(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Trying to fetch state from %s", id=74)
    public void tryingToFetchState(Address var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not find available peer for state, backing off and retrying", id=75)
    public void couldNotFindPeerForState();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Successfully retrieved and applied state from %s", id=76)
    public void successfullyAppliedState(Address var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Message or message buffer is null or empty.", id=77)
    public void msgOrMsgBufferEmpty();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Starting JGroups Channel", id=78)
    public void startingJGroupsChannel();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Cache local address is %s, physical addresses are %s", id=79)
    public void localAndPhysicalAddress(Address var1, List<Address> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Disconnecting and closing JGroups Channel", id=80)
    public void disconnectAndCloseJGroups();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Problem closing channel; setting it to null", id=81)
    public void problemClosingChannel(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Stopping the RpcDispatcher", id=82)
    public void stoppingRpcDispatcher();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Class [%s] cannot be cast to JGroupsChannelLookup! Not using a channel lookup.", id=83)
    public void wrongTypeForJGroupsChannelLookup(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Errors instantiating [%s]! Not using a channel lookup.", id=84)
    public void errorInstantiatingJGroupsChannelLookup(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while trying to create a channel using config files: %s", id=85)
    public void errorCreatingChannelFromConfigFile(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while trying to create a channel using config XML: %s", id=86)
    public void errorCreatingChannelFromXML(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while trying to create a channel using config string: %s", id=87)
    public void errorCreatingChannelFromConfigString(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to use any JGroups configuration mechanisms provided in properties %s. Using default JGroups configuration!", id=88)
    public void unableToUseJGroupsPropertiesProvided(TypedProperties var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="getCoordinator(): Interrupted while waiting for members to be set", id=89)
    public void interruptedWaitingForCoordinator(@Cause InterruptedException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to retrieve state from member %s", id=90)
    public void unableToRetrieveState(Address var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Channel does not contain STREAMING_STATE_TRANSFER. Cannot support state transfers!", id=91)
    public void streamingStateTransferNotPresent();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Channel not set up properly!", id=92)
    public void channelNotSetUp();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Received new, MERGED cluster view: %s", id=93)
    public void receivedMergedView(View var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Received new cluster view: %s", id=94)
    public void receivedClusterView(View var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Caught while responding to state transfer request", id=95)
    public void errorGeneratingState(@Cause StateTransferException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Caught while requesting or applying state", id=96)
    public void errorRequestingOrApplyingState(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while processing 1PC PrepareCommand", id=97)
    public void errorProcessing1pcPrepareCommand(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception while rollback", id=98)
    public void errorRollingBack(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unprocessed Transaction Log Entries! = %d", id=99)
    public void unprocessedTxLogEntries(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Stopping, but there are transactions that did not finish in time: localTransactions=%s, remoteTransactions%s", id=100)
    public void unfinishedTransactionsRemain(ConcurrentMap<Transaction, LocalTransaction> var1, ConcurrentMap<GlobalTransaction, RemoteTransaction> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed synchronization registration", id=101)
    public void failedSynchronizationRegistration(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to roll back global transaction %s", id=102)
    public void unableToRollbackGlobalTx(GlobalTransaction var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="A remote transaction with the given id was already registered!!!", id=103)
    public void remoteTxAlreadyRegistered();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Falling back to DummyTransactionManager from Infinispan", id=104)
    public void fallingBackToDummyTm();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed creating initial JNDI context", id=105)
    public void failedToCreateInitialCtx(@Cause NamingException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Found WebSphere TransactionManager factory class [%s], but couldn't invoke its static 'getTransactionManager' method", id=106)
    public void unableToInvokeWebsphereStaticGetTmMethod(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Retrieving transaction manager %s", id=107)
    public void retrievingTm(TransactionManager var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error enlisting resource", id=108)
    public void errorEnlistingResource(@Cause XAException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="beforeCompletion() failed for %s", id=109)
    public void beforeCompletionFailed(Synchronization var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error from resource manager!", id=110)
    public void unexpectedErrorFromResourceManager(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="afterCompletion() failed for %s", id=111)
    public void afterCompletionFailed(Synchronization var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="exception while committing", id=112)
    public void errorCommittingTx(@Cause XAException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unbinding of DummyTransactionManager failed", id=113)
    public void unbindingDummyTmFailed(@Cause NamingException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unsupported combination (dldEnabled, recoveryEnabled, xa) = (%s, %s, %s)", id=114)
    public void unsupportedTransactionConfiguration(boolean var1, boolean var2, boolean var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Recovery call will be ignored as recovery is disabled. More on recovery: http://community.jboss.org/docs/DOC-16646", id=115)
    public void recoveryIgnored();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Missing the list of prepared transactions from node %s. Received response is %s", id=116)
    public void missingListPreparedTransactions(Object var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="There's already a prepared transaction with this xid: %s. New transaction is %s. Are there two different transactions having same Xid in the cluster?", id=117)
    public void preparedTxAlreadyExists(RecoveryAwareTransaction var1, RecoveryAwareRemoteTransaction var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not load module at URL %s", id=118)
    public void couldNotLoadModuleAtUrl(URL var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Module %s loaded, but could not be initialized", id=119)
    public void couldNotInitializeModule(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Invocation of %s threw an exception %s. Exception is ignored.", id=120)
    public void ignoringException(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to set value!", id=121)
    public void unableToSetValue(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to an int! Using default value of %d", id=122)
    public void unableToConvertStringPropertyToInt(String var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to a long! Using default value of %d", id=123)
    public void unableToConvertStringPropertyToLong(String var1, long var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to a boolean! Using default value of %b", id=124)
    public void unableToConvertStringPropertyToBoolean(String var1, boolean var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to invoke getter %s on Configuration.class!", id=125)
    public void unableToInvokeGetterOnConfiguration(Method var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempted to stop() from FAILED state, but caught exception; try calling destroy()", id=126)
    public void failedToCallStopAfterFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Needed to call stop() before destroying but stop() threw exception. Proceeding to destroy", id=127)
    public void stopBeforeDestroyFailed(@Cause CacheException var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Infinispan version: %s", id=128)
    public void version(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Received a remote call but the cache is not in STARTED state - ignoring call.", id=129)
    public void cacheNotStarted();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Caught exception! Aborting join.", id=130)
    public void abortingJoin(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%s completed join rehash in %s!", id=131)
    public void joinRehashCompleted(Address var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%s aborted join rehash after %s!", id=132)
    public void joinRehashAborted(Address var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempted to register listener of class %s, but no valid, public methods annotated with method-level event annotations found! Ignoring listener.", id=133)
    public void noAnnotateMethodsFoundInListener(Class var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to invoke method %s on Object instance %s - removing this target object from list of listeners!", id=134)
    public void unableToInvokeListenerMethod(Method var1, Object var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not lock key %s in order to invalidate from L1 at node %s, skipping....", id=135)
    public void unableToLockToInvalidate(Object var1, Address var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Execution error", id=136)
    public void executionError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Failed invalidating remote cache", id=137)
    public void failedInvalidatingRemoteCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Could not register object with name: %s", id=138)
    public void couldNotRegisterObjectName(ObjectName var1, @Cause InstanceAlreadyExistsException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Infinispan configuration schema could not be resolved locally nor fetched from URL. Local path=%s, schema path=%s, schema URL=%s", id=139)
    public void couldNotResolveConfigurationSchema(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Lazy deserialization configuration is deprecated, please use storeAsBinary instead", id=140)
    public void lazyDeserializationDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not rollback prepared 1PC transaction. This transaction will be rolled back by the recovery process, if enabled. Transaction: %s", id=141)
    public void couldNotRollbackPrepared1PcTransaction(LocalTransaction var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The async store shutdown timeout (%d ms) is too high compared to cache stop timeout (%d ms), so instead using %d ms for async store stop wait", id=142)
    public void asyncStoreShutdownTimeoutTooHigh(long var1, long var3, long var5);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Received a key that doesn't map to this node: %s, mapped to %s", id=143)
    public void keyDoesNotMapToLocalNode(Object var1, Collection<Address> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed loading value for key %s from cache store", id=144)
    public void failedLoadingValueFromCacheStore(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error during rehash", id=145)
    public void errorDuringRehash(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error transferring state to node after rehash", id=146)
    public void errorTransferringState(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error invalidating keys from L1 after rehash", id=147)
    public void failedToInvalidateKeys(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Invalid %s value of %s. It can not be higher than %s which is %s", id=148)
    public void invalidTimeoutValue(Object var1, Object var2, Object var3, Object var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Fetch persistent state and purge on startup are both disabled, cache may contain stale entries on startup", id=149)
    public void staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup();

    @LogMessage(level=Logger.Level.FATAL)
    @Message(value="Rehash command received on non-distributed cache. All the nodes in the cluster should be using the same configuration.", id=150)
    public void rehashCommandReceivedOnNonDistributedCache();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error flushing to file: %s", id=151)
    public void errorFlushingToFileChannel(FileChannel var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Passivation configured without a valid eviction policy. This could mean that the cache store will never get used unless code calls Cache.evict() manually.", id=152)
    public void passivationWithoutEviction();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Ignoring eviction wakeUpInterval configuration since it is deprecated, please configure Expiration's wakeUpInterval instead", id=153)
    public void evictionWakeUpIntervalDeprecated();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to unlock keys %2$s for transaction %1$s after they were rebalanced off node %3$s", id=154)
    public void unableToUnlockRebalancedKeys(GlobalTransaction var1, List<Object> var2, Address var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Timed out waiting for all cluster members to confirm pushing data for view %d, received confirmations %s. Cancelling state transfer", id=157)
    public void stateTransferTimeoutWaitingForPushConfirmations(int var1, Map<Address, Integer> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Timed out waiting for all cluster members to confirm joining for view %d, joined %s. Cancelling state transfer", id=158)
    public void stateTransferTimeoutWaitingForJoinConfirmations(int var1, Map<Address, Integer> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unblocking transactions failed", id=159)
    public void errorUnblockingTransactions(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not complete injected transaction.", id=160)
    public void couldNotCompleteInjectedTransaction(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Using a batchMode transaction manager", id=161)
    public void usingBatchModeTransactionManager();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Could not instantiate transaction manager", id=162)
    public void couldNotInstantiateTransactionManager(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="FileCacheStore ignored an unexpected file %2$s in path %1$s. The store path should be dedicated!", id=163)
    public void chacheLoaderIgnoringUnexpectedFile(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Rolling back to cache view %d, but last committed view is %d", id=164)
    public void cacheViewRollbackIdMismatch(int var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error triggering a view installation for cache %s", id=165)
    public void errorTriggeringViewInstallation(@Cause RuntimeException var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="View installation failed for cache %s", id=166)
    public void viewInstallationFailure(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Rejecting state pushed by node %s for view %d, there is no state transfer in progress (we are at view %d)", id=167)
    public void remoteStateRejected(Address var1, int var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error rolling back to cache view %1$d for cache %2$s", id=168)
    public void cacheViewRollbackFailure(@Cause Throwable var1, int var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error committing cache view %1$d for cache %2$s", id=169)
    public void cacheViewCommitFailure(@Cause Throwable var1, int var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Our last committed view (%s) is not the same as the coordinator's last committed view (%s). This is normal during a merge", id=170)
    public void prepareViewIdMismatch(CacheView var1, CacheView var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Strict peer-to-peer is enabled but the JGroups channel was started externally - this is very likely to result in RPC timeout errors on startup", id=171)
    public void warnStrictPeerToPeerWithInjectedChannel();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to prepare view %s for cache  %s, rolling back to view %s", id=172)
    public void cacheViewPrepareFailure(@Cause Throwable var1, CacheView var2, String var3, CacheView var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Custom interceptor %s has used @Inject, @Start or @Stop. These methods will not be processed.  Please extend org.infinispan.interceptors.base.BaseCustomInterceptor instead, and your custom interceptor will have access to a cache and cacheManager.  Override stop() and start() for lifecycle methods.", id=173)
    public void customInterceptorExpectsInjection(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unexpected error reading configuration", id=174)
    public void errorReadingConfiguration(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unexpected error closing resource", id=175)
    public void failedToCloseResource(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The 'wakeUpInterval' attribute of the 'eviction' configuration XML element is deprecated. Setting the 'wakeUpInterval' attribute of the 'expiration' configuration XML element to %d instead", id=176)
    public void evictionWakeUpIntervalDeprecated(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="%s has been deprecated as a synonym for %s. Use one of %s instead", id=177)
    public void randomCacheModeSynonymsDeprecated(String var1, String var2, List<String> var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="stateRetrieval's 'alwaysProvideInMemoryState' attribute is no longer in use, instead please make sure all instances of this named cache in the cluster have 'fetchInMemoryState' attribute enabled", id=178)
    public void alwaysProvideInMemoryStateDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="stateRetrieval's 'initialRetryWaitTime' attribute is no longer in use.", id=179)
    public void initialRetryWaitTimeDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="stateRetrieval's 'logFlushTimeout' attribute is no longer in use.", id=180)
    public void logFlushTimeoutDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="stateRetrieval's 'maxProgressingLogWrites' attribute is no longer in use.", id=181)
    public void maxProgressingLogWritesDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="stateRetrieval's 'numRetries' attribute is no longer in use.", id=182)
    public void numRetriesDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="stateRetrieval's 'retryWaitTimeIncreaseFactor' attribute is no longer in use.", id=183)
    public void retryWaitTimeIncreaseFactorDeprecated();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="The stateRetrieval configuration element has been deprecated, we're assuming you meant stateTransfer. Please see XML schema for more information.", id=184)
    public void stateRetrievalConfigurationDeprecaced();
}

