/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.BackupFailurePolicy;

public class BackupConfiguration {
    private final String site;
    private final BackupStrategy strategy;
    private long timeout;
    private final BackupFailurePolicy backupFailurePolicy;
    private final String failurePolicyClass;

    public BackupConfiguration(String site, BackupStrategy strategy, long timeout, BackupFailurePolicy backupFailurePolicy, String failurePolicyClass) {
        this.site = site;
        this.strategy = strategy;
        this.timeout = timeout;
        this.backupFailurePolicy = backupFailurePolicy;
        this.failurePolicyClass = failurePolicyClass;
    }

    public String site() {
        return this.site;
    }

    public BackupStrategy strategy() {
        return this.strategy;
    }

    public String failurePolicyClass() {
        return this.failurePolicyClass;
    }

    public boolean isAsyncBackup() {
        return this.strategy() == BackupStrategy.ASYNC;
    }

    public long replicationTimeout() {
        return this.timeout;
    }

    public BackupFailurePolicy backupFailurePolicy() {
        return this.backupFailurePolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackupConfiguration)) {
            return false;
        }
        BackupConfiguration that = (BackupConfiguration)o;
        if (this.timeout != that.timeout) {
            return false;
        }
        if (this.backupFailurePolicy != that.backupFailurePolicy) {
            return false;
        }
        if (this.failurePolicyClass != null ? !this.failurePolicyClass.equals(that.failurePolicyClass) : that.failurePolicyClass != null) {
            return false;
        }
        if (this.site != null ? !this.site.equals(that.site) : that.site != null) {
            return false;
        }
        return this.strategy == that.strategy;
    }

    public int hashCode() {
        int result = this.site != null ? this.site.hashCode() : 0;
        result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
        result = 31 * result + (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + (this.backupFailurePolicy != null ? this.backupFailurePolicy.hashCode() : 0);
        result = 31 * result + (this.failurePolicyClass != null ? this.failurePolicyClass.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BackupConfiguration{site='" + this.site + '\'' + ", strategy=" + (Object)((Object)this.strategy) + ", timeout=" + this.timeout + ", backupFailurePolicy=" + (Object)((Object)this.backupFailurePolicy) + ", failurePolicyClass='" + this.failurePolicyClass + '\'' + '}';
    }

    public static enum BackupStrategy {
        SYNC,
        ASYNC;

    }
}

