/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.ConfigurationBuilder;

public class BackupConfigurationBuilder
extends AbstractConfigurationChildBuilder<BackupConfiguration> {
    private String site;
    private BackupConfiguration.BackupStrategy strategy = BackupConfiguration.BackupStrategy.ASYNC;
    private long replicationTimeout = 10000L;
    private BackupFailurePolicy backupFailurePolicy = BackupFailurePolicy.WARN;
    private String failurePolicyClass;

    public BackupConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public BackupConfigurationBuilder site(String site) {
        this.site = site;
        return this;
    }

    public String site() {
        return this.site;
    }

    public String failurePolicyClass() {
        return this.failurePolicyClass;
    }

    public BackupConfigurationBuilder failurePolicyClass(String failurePolicy) {
        this.failurePolicyClass = failurePolicy;
        return this;
    }

    public BackupConfigurationBuilder replicationTimeout(long replicationTimeout) {
        this.replicationTimeout = replicationTimeout;
        return this;
    }

    public long replicationTimeout() {
        return this.replicationTimeout;
    }

    public BackupConfigurationBuilder strategy(BackupConfiguration.BackupStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public BackupConfiguration.BackupStrategy strategy() {
        return this.strategy;
    }

    public BackupConfigurationBuilder backupFailurePolicy(BackupFailurePolicy backupFailurePolicy) {
        this.backupFailurePolicy = backupFailurePolicy;
        return this;
    }

    public BackupFailurePolicy backupFailurePolicy() {
        return this.backupFailurePolicy;
    }

    @Override
    public void validate() {
        if (this.site == null) {
            throw new ConfigurationException("The 'site' must be specified!");
        }
        if (this.backupFailurePolicy == BackupFailurePolicy.CUSTOM && this.failurePolicyClass == null) {
            throw new ConfigurationException("It is required to specify a 'failurePolicyClass' when using a custom backup failure policy!");
        }
    }

    @Override
    public BackupConfiguration create() {
        return new BackupConfiguration(this.site, this.strategy, this.replicationTimeout, this.backupFailurePolicy, this.failurePolicyClass);
    }

    @Override
    public Builder read(BackupConfiguration template) {
        this.site = template.site();
        this.strategy = template.strategy();
        this.backupFailurePolicy = template.backupFailurePolicy();
        this.replicationTimeout = template.replicationTimeout();
        this.failurePolicyClass = template.failurePolicyClass();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackupConfigurationBuilder)) {
            return false;
        }
        BackupConfigurationBuilder that = (BackupConfigurationBuilder)o;
        if (this.replicationTimeout != that.replicationTimeout) {
            return false;
        }
        if (this.backupFailurePolicy != that.backupFailurePolicy) {
            return false;
        }
        if (this.site != null ? !this.site.equals(that.site) : that.site != null) {
            return false;
        }
        if (this.failurePolicyClass != null ? !this.failurePolicyClass.equals(that.failurePolicyClass) : that.failurePolicyClass != null) {
            return false;
        }
        return this.strategy == that.strategy;
    }

    public int hashCode() {
        int result = this.site != null ? this.site.hashCode() : 0;
        result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
        result = 31 * result + (int)(this.replicationTimeout ^ this.replicationTimeout >>> 32);
        result = 31 * result + (this.backupFailurePolicy != null ? this.backupFailurePolicy.hashCode() : 0);
        result = 31 * result + (this.failurePolicyClass != null ? this.failurePolicyClass.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BackupConfigurationBuilder{site='" + this.site + '\'' + ", strategy=" + (Object)((Object)this.strategy) + ", replicationTimeout=" + this.replicationTimeout + ", backupFailurePolicy=" + (Object)((Object)this.backupFailurePolicy) + ", failurePolicyClass=" + this.failurePolicyClass + '}';
    }
}

