/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.beans.PropertyEditorSupport;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.configuration.cache.AbstractLockSupportCacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfiguration;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.util.TypedProperties;

public class FileCacheStoreConfigurationBuilder
extends AbstractLockSupportCacheStoreConfigurationBuilder<FileCacheStoreConfiguration, FileCacheStoreConfigurationBuilder> {
    private String location = "Infinispan-FileCacheStore";
    private long fsyncInterval = TimeUnit.SECONDS.toMillis(1L);
    private FsyncMode fsyncMode = FsyncMode.DEFAULT;
    private int streamBufferSize = 8192;

    public FileCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public FileCacheStoreConfigurationBuilder self() {
        return this;
    }

    public FileCacheStoreConfigurationBuilder location(String location) {
        this.location = location;
        return this;
    }

    public FileCacheStoreConfigurationBuilder fsyncInterval(long fsyncInterval) {
        this.fsyncInterval = fsyncInterval;
        return this;
    }

    public FileCacheStoreConfigurationBuilder fsyncInterval(long fsyncInterval, TimeUnit unit) {
        return this.fsyncInterval(unit.toMillis(fsyncInterval));
    }

    public FileCacheStoreConfigurationBuilder fsyncMode(FsyncMode fsyncMode) {
        this.fsyncMode = fsyncMode;
        return this;
    }

    public FileCacheStoreConfigurationBuilder streamBufferSize(int streamBufferSize) {
        this.streamBufferSize = streamBufferSize;
        return this;
    }

    @Override
    public FileCacheStoreConfigurationBuilder withProperties(Properties p) {
        this.properties = p;
        XmlConfigHelper.setValues(this, this.properties, false, true);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public FileCacheStoreConfiguration create() {
        return new FileCacheStoreConfiguration(this.location, this.fsyncInterval, this.fsyncMode, this.streamBufferSize, this.lockAcquistionTimeout, this.lockConcurrencyLevel, this.purgeOnStartup, this.purgeSynchronously, this.purgerThreads, this.fetchPersistentState, this.ignoreModifications, TypedProperties.toTypedProperties(this.properties), this.async.create(), this.singletonStore.create());
    }

    public FileCacheStoreConfigurationBuilder read(FileCacheStoreConfiguration template) {
        this.fsyncInterval = template.fsyncInterval();
        this.fsyncMode = template.fsyncMode();
        this.location = template.location();
        this.streamBufferSize = template.streamBufferSize();
        this.lockAcquistionTimeout = template.lockAcquistionTimeout();
        this.lockConcurrencyLevel = template.lockConcurrencyLevel();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.purgeSynchronously = template.purgeSynchronously();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return this;
    }

    public String toString() {
        return "FileCacheStoreConfigurationBuilder{fetchPersistentState=" + this.fetchPersistentState + ", location='" + this.location + '\'' + ", fsyncInterval=" + this.fsyncInterval + ", fsyncMode=" + (Object)((Object)this.fsyncMode) + ", streamBufferSize=" + this.streamBufferSize + ", ignoreModifications=" + this.ignoreModifications + ", purgeOnStartup=" + this.purgeOnStartup + ", purgerThreads=" + this.purgerThreads + ", purgeSynchronously=" + this.purgeSynchronously + ", lockConcurrencyLevel=" + this.lockConcurrencyLevel + ", lockAcquistionTimeout=" + this.lockAcquistionTimeout + ", properties=" + this.properties + ", async=" + this.async + ", singletonStore=" + this.singletonStore + '}';
    }

    @Deprecated
    public static class FsyncModeEditor
    extends PropertyEditorSupport {
        private FsyncMode mode;

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            if (text.equals("default")) {
                this.mode = FsyncMode.DEFAULT;
            } else if (text.equals("perWrite")) {
                this.mode = FsyncMode.PER_WRITE;
            } else if (text.equals("periodic")) {
                this.mode = FsyncMode.PERIODIC;
            } else {
                throw new IllegalArgumentException("Unknown fsyncMode value: " + text);
            }
        }

        @Override
        public Object getValue() {
            return this.mode;
        }
    }

    public static enum FsyncMode {
        DEFAULT,
        PER_WRITE,
        PERIODIC;

    }
}

