/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.AbstractLoaderConfigurationChildBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;

public class SingletonStoreConfigurationBuilder
extends AbstractLoaderConfigurationChildBuilder<SingletonStoreConfiguration> {
    private boolean enabled = false;
    private long pushStateTimeout = TimeUnit.SECONDS.toMillis(10L);
    private boolean pushStateWhenCoordinator = true;

    SingletonStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    public SingletonStoreConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public SingletonStoreConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SingletonStoreConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public SingletonStoreConfigurationBuilder pushStateTimeout(long l) {
        this.pushStateTimeout = l;
        return this;
    }

    public SingletonStoreConfigurationBuilder pushStateTimeout(long l, TimeUnit unit) {
        return this.pushStateTimeout(unit.toMillis(l));
    }

    public SingletonStoreConfigurationBuilder pushStateWhenCoordinator(boolean b) {
        this.pushStateWhenCoordinator = b;
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public SingletonStoreConfiguration create() {
        return new SingletonStoreConfiguration(this.enabled, this.pushStateTimeout, this.pushStateWhenCoordinator);
    }

    public SingletonStoreConfigurationBuilder read(SingletonStoreConfiguration template) {
        this.enabled = template.enabled();
        this.pushStateTimeout = template.pushStateTimeout();
        this.pushStateWhenCoordinator = template.pushStateWhenCoordinator();
        return this;
    }

    public String toString() {
        return "SingletonStoreConfigurationBuilder{enabled=" + this.enabled + ", pushStateTimeout=" + this.pushStateTimeout + ", pushStateWhenCoordinator=" + this.pushStateWhenCoordinator + '}';
    }
}

