/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.List;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BackupForConfiguration;

public class SitesConfiguration {
    private final List<BackupConfiguration> backups;
    private final BackupForConfiguration backupFor;
    private final boolean disableBackups;

    public SitesConfiguration(List<BackupConfiguration> backups, BackupForConfiguration backupFor, boolean disableBackups) {
        this.backups = backups;
        this.backupFor = backupFor;
        this.disableBackups = disableBackups;
    }

    public boolean disableBackups() {
        return this.disableBackups;
    }

    public List<BackupConfiguration> backups() {
        return this.backups;
    }

    public BackupForConfiguration backupFor() {
        return this.backupFor;
    }

    public BackupFailurePolicy getFailurePolicy(String siteName) {
        for (BackupConfiguration bc : this.backups) {
            if (!bc.site().equals(siteName)) continue;
            return bc.backupFailurePolicy();
        }
        throw new IllegalStateException("There must be a site configured for " + siteName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SitesConfiguration)) {
            return false;
        }
        SitesConfiguration that = (SitesConfiguration)o;
        if (this.disableBackups != that.disableBackups) {
            return false;
        }
        if (this.backupFor != null ? !this.backupFor.equals(that.backupFor) : that.backupFor != null) {
            return false;
        }
        return !(this.backups != null ? !((Object)this.backups).equals(that.backups) : that.backups != null);
    }

    public int hashCode() {
        int result = this.backups != null ? ((Object)this.backups).hashCode() : 0;
        result = 31 * result + (this.backupFor != null ? this.backupFor.hashCode() : 0);
        result = 31 * result + (this.disableBackups ? 1 : 0);
        return result;
    }

    public String toString() {
        return "SitesConfiguration{backups=" + this.backups + ", backupFor=" + this.backupFor + ", disableBackups=" + this.disableBackups + '}';
    }
}

