/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupForBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfiguration;

public class SitesConfigurationBuilder
extends AbstractConfigurationChildBuilder<SitesConfiguration> {
    private static final int DEFAULT_BACKUP_COUNT = 2;
    private final List<BackupConfigurationBuilder> backups = new ArrayList<BackupConfigurationBuilder>(2);
    private final BackupForBuilder backupForBuilder;
    private boolean disableBackups;

    public SitesConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.backupForBuilder = new BackupForBuilder(builder);
    }

    public BackupConfigurationBuilder addBackup() {
        BackupConfigurationBuilder bcb = new BackupConfigurationBuilder(this.getBuilder());
        this.backups.add(bcb);
        return bcb;
    }

    public List<BackupConfigurationBuilder> backups() {
        return this.backups;
    }

    public BackupForBuilder backupFor() {
        return this.backupForBuilder;
    }

    @Override
    public void validate() {
        this.backupForBuilder.validate();
        HashSet<String> backupNames = new HashSet<String>(2);
        for (BackupConfigurationBuilder bcb : this.backups) {
            if (backupNames.add(bcb.site())) continue;
            throw new ConfigurationException("Multiple sites with name '" + bcb.site() + "' are configured. That is not allowed!");
        }
    }

    @Override
    public SitesConfiguration create() {
        ArrayList<BackupConfiguration> backupConfigurations = new ArrayList<BackupConfiguration>(2);
        for (BackupConfigurationBuilder bcb : this.backups) {
            backupConfigurations.add(bcb.create());
        }
        return new SitesConfiguration(backupConfigurations, this.backupForBuilder.create(), this.disableBackups);
    }

    @Override
    public Builder read(SitesConfiguration template) {
        this.backupForBuilder.read(template.backupFor());
        for (BackupConfiguration bc : template.backups()) {
            BackupConfigurationBuilder bcb = new BackupConfigurationBuilder(this.getBuilder());
            bcb.read(bc);
            this.backups.add(bcb);
        }
        this.disableBackups = template.disableBackups();
        return this;
    }

    public void disableBackups(boolean disable) {
        this.disableBackups = disable;
    }
}

