/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.RecoveryConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;

public class TransactionConfigurationBuilder
extends AbstractConfigurationChildBuilder<TransactionConfiguration> {
    private boolean autoCommit = true;
    private long cacheStopTimeout = TimeUnit.SECONDS.toMillis(30L);
    private boolean eagerLockingSingleNode = false;
    LockingMode lockingMode = LockingMode.OPTIMISTIC;
    private boolean syncCommitPhase = true;
    private boolean syncRollbackPhase = false;
    private TransactionManagerLookup transactionManagerLookup = new GenericTransactionManagerLookup();
    private TransactionSynchronizationRegistryLookup transactionSynchronizationRegistryLookup;
    TransactionMode transactionMode = null;
    private boolean useEagerLocking = false;
    private boolean useSynchronization = false;
    private final RecoveryConfigurationBuilder recovery = new RecoveryConfigurationBuilder(this);
    private boolean use1PcForAutoCommitTransactions = false;

    TransactionConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public TransactionConfigurationBuilder autoCommit(boolean b) {
        this.autoCommit = b;
        return this;
    }

    public TransactionConfigurationBuilder cacheStopTimeout(long l) {
        this.cacheStopTimeout = l;
        return this;
    }

    public TransactionConfigurationBuilder cacheStopTimeout(long l, TimeUnit unit) {
        return this.cacheStopTimeout(unit.toMillis(l));
    }

    @Deprecated
    public TransactionConfigurationBuilder eagerLockingSingleNode(boolean b) {
        this.eagerLockingSingleNode = b;
        return this;
    }

    public TransactionConfigurationBuilder lockingMode(LockingMode lockingMode) {
        this.lockingMode = lockingMode;
        return this;
    }

    public TransactionConfigurationBuilder syncCommitPhase(boolean b) {
        this.syncCommitPhase = b;
        return this;
    }

    public TransactionConfigurationBuilder syncRollbackPhase(boolean b) {
        this.syncRollbackPhase = b;
        return this;
    }

    public TransactionConfigurationBuilder transactionManagerLookup(TransactionManagerLookup tml) {
        this.transactionManagerLookup = tml;
        return this;
    }

    public TransactionConfigurationBuilder transactionSynchronizationRegistryLookup(TransactionSynchronizationRegistryLookup lookup) {
        this.transactionSynchronizationRegistryLookup = lookup;
        return this;
    }

    public TransactionConfigurationBuilder transactionMode(TransactionMode transactionMode) {
        this.transactionMode = transactionMode;
        return this;
    }

    @Deprecated
    public TransactionConfigurationBuilder useEagerLocking(boolean b) {
        this.useEagerLocking = b;
        return this;
    }

    public TransactionConfigurationBuilder useSynchronization(boolean b) {
        this.useSynchronization = b;
        return this;
    }

    public RecoveryConfigurationBuilder recovery() {
        this.recovery.enable();
        return this.recovery;
    }

    public TransactionConfigurationBuilder use1PcForAutoCommitTransactions(boolean b) {
        this.use1PcForAutoCommitTransactions = b;
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public TransactionConfiguration create() {
        if (this.useEagerLocking) {
            this.lockingMode = LockingMode.PESSIMISTIC;
        }
        if (this.transactionMode == null && this.getBuilder().invocationBatching().enabled) {
            this.transactionMode = TransactionMode.TRANSACTIONAL;
        } else if (this.transactionMode == null) {
            this.transactionMode = TransactionMode.NON_TRANSACTIONAL;
        }
        return new TransactionConfiguration(this.autoCommit, this.cacheStopTimeout, this.eagerLockingSingleNode, this.lockingMode, this.syncCommitPhase, this.syncRollbackPhase, this.transactionManagerLookup, this.transactionSynchronizationRegistryLookup, this.transactionMode, this.useEagerLocking, this.useSynchronization, this.use1PcForAutoCommitTransactions, this.recovery.create());
    }

    public TransactionConfigurationBuilder read(TransactionConfiguration template) {
        this.autoCommit = template.autoCommit();
        this.cacheStopTimeout = template.cacheStopTimeout();
        this.eagerLockingSingleNode = template.eagerLockingSingleNode();
        this.lockingMode = template.lockingMode();
        this.syncCommitPhase = template.syncCommitPhase();
        this.syncRollbackPhase = template.syncRollbackPhase();
        this.transactionManagerLookup = template.transactionManagerLookup();
        this.transactionMode = template.transactionMode();
        this.transactionSynchronizationRegistryLookup = template.transactionSynchronizationRegistryLookup();
        this.useEagerLocking = template.useEagerLocking();
        this.useSynchronization = template.useSynchronization();
        this.use1PcForAutoCommitTransactions = template.use1PcForAutoCommitTransactions();
        this.recovery.read(template.recovery());
        return this;
    }

    public String toString() {
        return "TransactionConfigurationBuilder{autoCommit=" + this.autoCommit + ", cacheStopTimeout=" + this.cacheStopTimeout + ", eagerLockingSingleNode=" + this.eagerLockingSingleNode + ", lockingMode=" + (Object)((Object)this.lockingMode) + ", syncCommitPhase=" + this.syncCommitPhase + ", syncRollbackPhase=" + this.syncRollbackPhase + ", transactionManagerLookup=" + this.transactionManagerLookup + ", transactionSynchronizationRegistryLookup=" + this.transactionSynchronizationRegistryLookup + ", transactionMode=" + (Object)((Object)this.transactionMode) + ", useEagerLocking=" + this.useEagerLocking + ", useSynchronization=" + this.useSynchronization + ", recovery=" + this.recovery + ", use1PcForAutoCommitTransactions=" + this.use1PcForAutoCommitTransactions + '}';
    }
}

