/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SiteConfiguration;

public class SiteConfigurationBuilder
extends AbstractGlobalConfigurationBuilder<SiteConfiguration> {
    private String name;

    SiteConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public SiteConfigurationBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    void validate() {
        if (this.name == null) {
            throw new ConfigurationException("Name is a required property for the site configuration.");
        }
    }

    @Override
    SiteConfiguration create() {
        return new SiteConfiguration(this.name);
    }

    protected SiteConfigurationBuilder read(SiteConfiguration template) {
        this.name = template.name();
        return this;
    }

    public String toString() {
        return "SiteConfigurationBuilder{name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SiteConfigurationBuilder)) {
            return false;
        }
        SiteConfigurationBuilder that = (SiteConfigurationBuilder)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    boolean isSameName(String localSite) {
        return localSite.equals(this.name);
    }
}

