/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationChildBuilder;
import org.infinispan.configuration.global.SiteConfiguration;
import org.infinispan.configuration.global.SiteConfigurationBuilder;
import org.infinispan.configuration.global.SitesConfiguration;

public class SitesConfigurationBuilder
extends AbstractGlobalConfigurationBuilder<SitesConfiguration> {
    private String localSite;
    private final List<SiteConfigurationBuilder> siteBuilders = new ArrayList<SiteConfigurationBuilder>(2);

    SitesConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public SitesConfigurationBuilder localSite(String localSite) {
        this.localSite = localSite;
        return this;
    }

    public SiteConfigurationBuilder addSite() {
        SiteConfigurationBuilder siteBuilder = new SiteConfigurationBuilder(this.getGlobalConfig());
        this.siteBuilders.add(siteBuilder);
        return siteBuilder;
    }

    @Override
    void validate() {
        if (this.siteBuilders.isEmpty()) {
            return;
        }
        if (this.localSite == null) {
            throw new ConfigurationException("'localSite' is required!");
        }
        boolean localSiteIsDefined = false;
        for (SiteConfigurationBuilder scb : this.siteBuilders) {
            scb.validate();
            if (!scb.isSameName(this.localSite)) continue;
            localSiteIsDefined = true;
        }
        if (!localSiteIsDefined) {
            throw new ConfigurationException("The name of the local site is not present between the defined sites!");
        }
    }

    @Override
    SitesConfiguration create() {
        ArrayList<SiteConfiguration> siteConfigurations = new ArrayList<SiteConfiguration>(this.siteBuilders.size());
        for (SiteConfigurationBuilder scb : this.siteBuilders) {
            siteConfigurations.add(scb.create());
        }
        return new SitesConfiguration(this.localSite, siteConfigurations);
    }

    @Override
    protected GlobalConfigurationChildBuilder read(SitesConfiguration template) {
        for (SiteConfiguration siteConfiguration : template.siteConfigurations()) {
            this.addSite().read(siteConfiguration);
        }
        this.localSite = template.localSite();
        return this;
    }

    public String toString() {
        return "SitesConfigurationBuilder{localSite='" + this.localSite + '\'' + ", siteBuilders=" + this.siteBuilders + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SitesConfigurationBuilder)) {
            return false;
        }
        SitesConfigurationBuilder that = (SitesConfigurationBuilder)o;
        if (this.localSite != null ? !this.localSite.equals(that.localSite) : that.localSite != null) {
            return false;
        }
        return ((Object)this.siteBuilders).equals(that.siteBuilders);
    }

    public int hashCode() {
        int result = this.localSite != null ? this.localSite.hashCode() : 0;
        result = 31 * result + ((Object)this.siteBuilders).hashCode();
        return result;
    }
}

