/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.ParserContext;

public class ConfigurationBuilderHolder {
    private final GlobalConfigurationBuilder globalConfigurationBuilder = new GlobalConfigurationBuilder();
    private final ConfigurationBuilder defaultConfigurationBuilder = new ConfigurationBuilder();
    private final Map<String, ConfigurationBuilder> namedConfigurationBuilders = new HashMap<String, ConfigurationBuilder>();
    private ConfigurationBuilder currentConfigurationBuilder = this.defaultConfigurationBuilder;
    private final Map<Class<? extends ConfigurationParser<?>>, ParserContext> parserContexts = new HashMap();
    private final ClassLoader classLoader;

    public ConfigurationBuilderHolder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public GlobalConfigurationBuilder getGlobalConfigurationBuilder() {
        return this.globalConfigurationBuilder;
    }

    public ConfigurationBuilder newConfigurationBuilder(String name) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.read(this.getDefaultConfigurationBuilder().build(false));
        this.namedConfigurationBuilders.put(name, builder);
        this.currentConfigurationBuilder = builder;
        return builder;
    }

    public ConfigurationBuilder getDefaultConfigurationBuilder() {
        return this.defaultConfigurationBuilder;
    }

    public Map<String, ConfigurationBuilder> getNamedConfigurationBuilders() {
        return this.namedConfigurationBuilders;
    }

    public ConfigurationBuilder getCurrentConfigurationBuilder() {
        return this.currentConfigurationBuilder;
    }

    public <T extends ParserContext> T getParserContext(Class<? extends ConfigurationParser<?>> parserClass) {
        return (T)this.parserContexts.get(parserClass);
    }

    public void setParserContext(Class<? extends ConfigurationParser<?>> parserClass, ParserContext context) {
        this.parserContexts.put(parserClass, context);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    Map<Class<? extends ConfigurationParser<?>>, ParserContext> getParserContexts() {
        return this.parserContexts;
    }
}

