/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    ADVANCED_EXTERNALIZER("advancedExternalizer"),
    ADVANCED_EXTERNALIZERS("advancedExternalizers"),
    ASYNC("async"),
    ASYNC_LISTENER_EXECUTOR("asyncListenerExecutor"),
    ASYNC_TRANSPORT_EXECUTOR("asyncTransportExecutor"),
    CLUSTERING("clustering"),
    CLUSTER_LOADER("clusterLoader"),
    CUSTOM_INTERCEPTORS("customInterceptors"),
    DATA_CONTAINER("dataContainer"),
    DEADLOCK_DETECTION("deadlockDetection"),
    DEFAULT("default"),
    EVICTION("eviction"),
    EVICTION_SCHEDULED_EXECUTOR("evictionScheduledExecutor"),
    EXPIRATION("expiration"),
    FILE_STORE("fileStore"),
    GROUPS("groups"),
    GROUPER("grouper"),
    GLOBAL("global"),
    GLOBAL_JMX_STATISTICS("globalJmxStatistics"),
    HASH("hash"),
    INDEXING("indexing"),
    INTERCEPTOR("interceptor"),
    INVOCATION_BATCHING("invocationBatching"),
    JMX_STATISTICS("jmxStatistics"),
    L1("l1"),
    LAZY_DESERIALIZATION("lazyDeserialization"),
    LOADER("loader"),
    LOADERS("loaders"),
    LOCKING("locking"),
    MODULES("modules"),
    NAMED_CACHE("namedCache"),
    PROPERTIES("properties"),
    PROPERTY("property"),
    RECOVERY("recovery"),
    REPLICATION_QUEUE_SCHEDULED_EXECUTOR("replicationQueueScheduledExecutor"),
    ROOT("infinispan"),
    SERIALIZATION("serialization"),
    SHUTDOWN("shutdown"),
    SINGLETON_STORE("singletonStore"),
    STATE_RETRIEVAL("stateRetrieval"),
    STATE_TRANSFER("stateTransfer"),
    STORE("store"),
    STORE_AS_BINARY("storeAsBinary"),
    SYNC("sync"),
    TRANSACTION("transaction"),
    TRANSPORT("transport"),
    UNSAFE("unsafe"),
    VERSIONING("versioning"),
    SITES("sites"),
    SITE("site"),
    BACKUPS("backups"),
    BACKUP("backup"),
    BACKUP_FOR("backupFor");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>(8);
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

