/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.hash.Hash;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Immutables;

@Immutable
public class DefaultConsistentHash
implements ConsistentHash {
    private final Hash hashFunction;
    private final int numSegments;
    private final int numOwners;
    private final List<Address> members;
    private final Address[][] segmentOwners;
    private final int segmentSize;

    public DefaultConsistentHash(Hash hashFunction, int numSegments, int numOwners, List<Address> members, List<Address>[] segmentOwners) {
        if (numSegments < 1) {
            throw new IllegalArgumentException("The number of segments must be strictly positive");
        }
        if (numOwners < 1) {
            throw new IllegalArgumentException("The number of owners must be strictly positive");
        }
        this.numSegments = numSegments;
        this.numOwners = numOwners;
        this.hashFunction = hashFunction;
        this.members = new ArrayList<Address>(members);
        this.segmentOwners = new Address[numSegments][];
        for (int i = 0; i < numSegments; ++i) {
            if (segmentOwners[i] == null || segmentOwners[i].isEmpty()) {
                throw new IllegalArgumentException("Segment owner list cannot be null or empty");
            }
            this.segmentOwners[i] = segmentOwners[i].toArray(new Address[segmentOwners[i].size()]);
        }
        this.segmentSize = (int)Math.ceil(2.147483647E9 / (double)numSegments);
    }

    @Override
    public Hash getHashFunction() {
        return this.hashFunction;
    }

    @Override
    public int getNumSegments() {
        return this.numSegments;
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (!this.members.contains(owner)) {
            throw new IllegalArgumentException("Node " + owner + " is not a member");
        }
        HashSet<Integer> segments = new HashSet<Integer>();
        block0: for (int i = 0; i < this.segmentOwners.length; ++i) {
            for (Address a : this.segmentOwners[i]) {
                if (!a.equals(owner)) continue;
                segments.add(i);
                continue block0;
            }
        }
        return segments;
    }

    @Override
    public int getSegment(Object key) {
        return this.getNormalizedHash(key) / this.segmentSize;
    }

    public int getNormalizedHash(Object key) {
        return this.hashFunction.hash(key) & Integer.MAX_VALUE;
    }

    public List<Integer> getSegmentEndHashes() {
        ArrayList<Integer> hashes = new ArrayList<Integer>(this.numSegments);
        for (int i = 0; i < this.numSegments; ++i) {
            hashes.add((i + 1) % this.numSegments * this.segmentSize);
        }
        return hashes;
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        return Immutables.immutableListWrap(this.segmentOwners[segmentId]);
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.segmentOwners[segmentId][0];
    }

    @Override
    public List<Address> getMembers() {
        return this.members;
    }

    @Override
    public int getNumOwners() {
        return this.numOwners;
    }

    @Override
    public Address locatePrimaryOwner(Object key) {
        return this.locatePrimaryOwnerForSegment(this.getSegment(key));
    }

    @Override
    public List<Address> locateOwners(Object key) {
        return this.locateOwnersForSegment(this.getSegment(key));
    }

    @Override
    public Set<Address> locateAllOwners(Collection<Object> keys) {
        HashSet<Integer> segments = new HashSet<Integer>();
        for (Object key : keys) {
            segments.add(this.getSegment(key));
        }
        HashSet<Address> owners = new HashSet<Address>();
        for (Integer segment : segments) {
            Collections.addAll(owners, this.segmentOwners[segment]);
        }
        return owners;
    }

    @Override
    public boolean isKeyLocalToNode(Address nodeAddress, Object key) {
        int segment = this.getSegment(key);
        for (Address a : this.segmentOwners[segment]) {
            if (!a.equals(nodeAddress)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConsistentHash that = (DefaultConsistentHash)o;
        if (this.numOwners != that.numOwners) {
            return false;
        }
        if (this.numSegments != that.numSegments) {
            return false;
        }
        if (!this.hashFunction.equals(that.hashFunction)) {
            return false;
        }
        if (!((Object)this.members).equals(that.members)) {
            return false;
        }
        for (int i = 0; i < this.numSegments; ++i) {
            if (Arrays.equals(this.segmentOwners[i], that.segmentOwners[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultConsistentHash{");
        sb.append("numSegments=").append(this.numSegments);
        sb.append(", numOwners=").append(this.numOwners);
        sb.append(", members=").append(this.members);
        sb.append(", segmentOwners={");
        for (int i = 0; i < this.numSegments; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(i).append(":");
            for (int j = 0; j < this.segmentOwners[i].length; ++j) {
                sb.append(' ').append(this.members.indexOf(this.segmentOwners[i][j]));
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public static class Externalizer
    extends AbstractExternalizer<DefaultConsistentHash> {
        @Override
        public void writeObject(ObjectOutput output, DefaultConsistentHash ch) throws IOException {
            output.writeInt(ch.numSegments);
            output.writeInt(ch.numOwners);
            output.writeObject(ch.members);
            output.writeObject(ch.hashFunction);
            output.writeObject(ch.segmentOwners);
        }

        @Override
        public DefaultConsistentHash readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            int numSegments = unmarshaller.readInt();
            int numOwners = unmarshaller.readInt();
            List members = (List)unmarshaller.readObject();
            Hash hash = (Hash)unmarshaller.readObject();
            Address[][] segmentOwners = (Address[][])unmarshaller.readObject();
            List[] segmentOwnerList = new List[segmentOwners.length];
            for (int i = 0; i < segmentOwners.length; ++i) {
                segmentOwnerList[i] = Arrays.asList(segmentOwners[i]);
            }
            return new DefaultConsistentHash(hash, numSegments, numOwners, members, segmentOwnerList);
        }

        @Override
        public Integer getId() {
            return 51;
        }

        @Override
        public Set<Class<? extends DefaultConsistentHash>> getTypeClasses() {
            return Collections.singleton(DefaultConsistentHash.class);
        }
    }
}

