/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.hash.Hash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.OwnershipStatistics;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DefaultConsistentHashFactory
implements ConsistentHashFactory<DefaultConsistentHash>,
Serializable {
    private static final Log log = LogFactory.getLog(DefaultConsistentHashFactory.class);

    @Override
    public DefaultConsistentHash create(Hash hashFunction, int numOwners, int numSegments, List<Address> members) {
        if (numOwners <= 0) {
            throw new IllegalArgumentException("The number of owners should be greater than 0");
        }
        int actualNumOwners = Math.min(numOwners, members.size());
        List[] segmentOwners = new List[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            segmentOwners[i] = new ArrayList(actualNumOwners);
            segmentOwners[i].add(members.get(i % members.size()));
        }
        DefaultConsistentHash baseCH = new DefaultConsistentHash(hashFunction, numSegments, numOwners, members, segmentOwners);
        return actualNumOwners > 1 ? this.rebalance(baseCH) : baseCH;
    }

    @Override
    public DefaultConsistentHash updateMembers(DefaultConsistentHash baseCH, List<Address> newMembers) {
        if (((Object)newMembers).equals(baseCH.getMembers())) {
            return baseCH;
        }
        return this.removeLeavers(baseCH, newMembers);
    }

    @Override
    public DefaultConsistentHash rebalance(DefaultConsistentHash baseCH) {
        Hash hashFunction = baseCH.getHashFunction();
        List<Address> nodes = baseCH.getMembers();
        OwnershipStatistics stats = this.computeStatistics(baseCH, nodes);
        List<Address>[] ownerLists = this.extractSegmentOwners(baseCH);
        List<Address>[] intOwnerLists = this.extractSegmentOwners(baseCH);
        this.addPrimaryOwners(nodes, baseCH.getNumSegments(), stats, ownerLists, intOwnerLists);
        this.addBackupOwners(baseCH.getNumOwners(), nodes, baseCH.getNumSegments(), stats, ownerLists, intOwnerLists);
        DefaultConsistentHash ch = new DefaultConsistentHash(hashFunction, baseCH.getNumSegments(), baseCH.getNumOwners(), nodes, ownerLists);
        return ch.equals(baseCH) ? baseCH : ch;
    }

    @Override
    public DefaultConsistentHash union(DefaultConsistentHash dch1, DefaultConsistentHash dch2) {
        if (!dch1.getHashFunction().equals(dch2.getHashFunction())) {
            throw new IllegalArgumentException("The consistent hash objects must have the same hash function");
        }
        if (dch1.getNumSegments() != dch2.getNumSegments()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of segments");
        }
        if (dch1.getNumOwners() != dch2.getNumOwners()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of owners");
        }
        ArrayList<Address> members = new ArrayList<Address>(dch1.getMembers());
        List<Address>[] segmentOwners = this.extractSegmentOwners(dch1);
        this.mergeLists(members, dch2.getMembers());
        for (int i = 0; i < segmentOwners.length; ++i) {
            this.mergeLists(segmentOwners[i], dch2.locateOwnersForSegment(i));
        }
        return new DefaultConsistentHash(dch1.getHashFunction(), dch1.getNumSegments(), dch1.getNumOwners(), members, segmentOwners);
    }

    private void mergeLists(List<Address> dest, List<Address> src) {
        for (Address a2 : src) {
            if (dest.contains(a2)) continue;
            dest.add(a2);
        }
    }

    private void addPrimaryOwners(List<Address> nodes, int numSegments, OwnershipStatistics stats, List<Address>[] ownerLists, List<Address>[] intOwnerLists) {
        Map<Address, Integer> expectedPrimaryOwned = this.computeExpectedPrimaryOwned(nodes, numSegments);
        List<Address> newPrimaryOwners = this.computeNewPrimaryOwners(nodes, stats, expectedPrimaryOwned);
        for (int i = numSegments - 1; i >= 0; --i) {
            Address primaryOwner = ownerLists[i].get(0);
            int primaryOwned = stats.getPrimaryOwned(primaryOwner);
            if (primaryOwned <= expectedPrimaryOwned.get(primaryOwner)) continue;
            Address newPrimaryOwner = this.removeOneOf(newPrimaryOwners, intOwnerLists[i]);
            if (newPrimaryOwner != null) {
                ownerLists[i].remove(newPrimaryOwner);
                ownerLists[i].add(0, newPrimaryOwner);
                stats.decPrimaryOwned(primaryOwner);
                stats.incPrimaryOwned(newPrimaryOwner);
                continue;
            }
            newPrimaryOwner = newPrimaryOwners.remove(0);
            intOwnerLists[i].add(newPrimaryOwner);
            ownerLists[i].add(0, newPrimaryOwner);
            stats.incOwned(newPrimaryOwner);
            stats.decPrimaryOwned(primaryOwner);
            stats.incPrimaryOwned(newPrimaryOwner);
        }
    }

    private List<Address>[] extractSegmentOwners(DefaultConsistentHash ch) {
        int numSegments = ch.getNumSegments();
        List[] segmentOwners = new List[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            segmentOwners[i] = new ArrayList<Address>(ch.locateOwnersForSegment(i));
        }
        return segmentOwners;
    }

    private void addBackupOwners(int numOwners, List<Address> nodes, int numSegments, OwnershipStatistics stats, List<Address>[] ownerLists, List<Address>[] intOwnerLists) {
        int owned;
        Address owner;
        int j;
        int i;
        int actualNumOwners = Math.min(numOwners, nodes.size());
        Map<Address, Integer> expectedOwned = this.computeExpectedOwned(nodes, actualNumOwners, numSegments);
        for (i = numSegments - 1; i >= 0; --i) {
            for (j = ownerLists[i].size() - 1; j >= 1 && ownerLists[i].size() > actualNumOwners; --j) {
                owner = ownerLists[i].get(j);
                owned = stats.getOwned(owner);
                if (owned <= expectedOwned.get(owner)) continue;
                ownerLists[i].remove(j);
                stats.decOwned(owner);
            }
        }
        for (i = numSegments - 1; i >= 0; --i) {
            for (j = ownerLists[i].size() - 1; j >= 1; --j) {
                owner = ownerLists[i].get(j);
                owned = stats.getOwned(owner);
                if (owned <= expectedOwned.get(owner) && ownerLists[i].size() <= actualNumOwners) continue;
                ownerLists[i].remove(j);
                stats.decOwned(owner);
            }
        }
        List<Address> newOwners = this.computeNewOwners(nodes, stats, expectedOwned);
        for (int i2 = 0; i2 < numSegments; ++i2) {
            for (int j2 = ownerLists[i2].size(); j2 < actualNumOwners; ++j2) {
                Address newOwner = this.removeNotOneOf(newOwners, ownerLists[i2]);
                if (newOwner != null) {
                    ownerLists[i2].add(newOwner);
                    if (!intOwnerLists[i2].contains(newOwner)) {
                        intOwnerLists[i2].add(newOwner);
                    }
                    stats.incOwned(newOwner);
                    continue;
                }
                Address rejectedNewOwner = newOwners.remove(0);
                this.stealOwner(numSegments, rejectedNewOwner, i2, ownerLists, intOwnerLists, stats);
            }
        }
        assert (newOwners.isEmpty()) : "Can't still have nodes to assign if all the segments have enough owners";
    }

    private void stealOwner(int numSegments, Address replacementOwner, int destSegment, List<Address>[] ownerLists, List<Address>[] intOwnerLists, OwnershipStatistics stats) {
        for (int i = numSegments - 1; i >= 0; --i) {
            if (ownerLists[i].contains(replacementOwner)) continue;
            for (int j = ownerLists[i].size() - 1; j >= 1; --j) {
                Address ownerToSteal = ownerLists[i].get(j);
                if (ownerLists[destSegment].contains(ownerToSteal)) continue;
                ownerLists[i].remove(j);
                ownerLists[destSegment].add(ownerToSteal);
                if (!intOwnerLists[destSegment].contains(ownerToSteal)) {
                    intOwnerLists[destSegment].add(ownerToSteal);
                }
                ownerLists[i].add(replacementOwner);
                if (!intOwnerLists[i].contains(replacementOwner)) {
                    intOwnerLists[i].add(replacementOwner);
                }
                stats.incOwned(replacementOwner);
                return;
            }
        }
        assert (false) : "It should always be possible to find a replacement owner";
    }

    private List<Address> computeNewPrimaryOwners(List<Address> nodes, OwnershipStatistics stats, Map<Address, Integer> expectedPrimaryOwned) {
        LinkedList<Address> newPrimaryOwners = new LinkedList<Address>();
        int[] toAdd = new int[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            Address node = nodes.get(i);
            toAdd[i] = expectedPrimaryOwned.get(node) - stats.getPrimaryOwned(node);
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < nodes.size(); ++i) {
                if (toAdd[i] <= 0) continue;
                newPrimaryOwners.add(nodes.get(i));
                int n = i;
                toAdd[n] = toAdd[n] - 1;
                changed = true;
            }
        }
        return newPrimaryOwners;
    }

    private List<Address> computeNewOwners(List<Address> nodes, OwnershipStatistics stats, Map<Address, Integer> expectedOwned) {
        LinkedList<Address> newOwners = new LinkedList<Address>();
        int[] toAdd = new int[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            Address node = nodes.get(i);
            toAdd[i] = expectedOwned.get(node) - stats.getOwned(node);
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < nodes.size(); ++i) {
                if (toAdd[i] <= 0) continue;
                newOwners.addFirst(nodes.get(i));
                int n = i;
                toAdd[n] = toAdd[n] - 1;
                changed = true;
            }
        }
        return newOwners;
    }

    private Map<Address, Integer> computeExpectedPrimaryOwned(List<Address> nodes, int numSegments) {
        int numNodes = nodes.size();
        HashMap<Address, Integer> expectedPrimaryOwned = new HashMap<Address, Integer>(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            if (i < numSegments % numNodes) {
                expectedPrimaryOwned.put(nodes.get(i), numSegments / numNodes + 1);
                continue;
            }
            expectedPrimaryOwned.put(nodes.get(i), numSegments / numNodes);
        }
        return expectedPrimaryOwned;
    }

    private Map<Address, Integer> computeExpectedOwned(List<Address> nodes, int numOwners, int numSegments) {
        int numNodes = nodes.size();
        HashMap<Address, Integer> expectedOwned = new HashMap<Address, Integer>(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            if (i < numSegments * numOwners % numNodes) {
                expectedOwned.put(nodes.get(i), numSegments * numOwners / numNodes + 1);
                continue;
            }
            expectedOwned.put(nodes.get(i), numSegments * numOwners / numNodes);
        }
        return expectedOwned;
    }

    private Address removeOneOf(List<Address> list, List<Address> searchFor) {
        Iterator<Address> it = list.iterator();
        while (it.hasNext()) {
            Address element = it.next();
            if (!searchFor.contains(element)) continue;
            it.remove();
            return element;
        }
        return null;
    }

    private Address removeNotOneOf(List<Address> list, List<Address> searchFor) {
        Iterator<Address> it = list.iterator();
        while (it.hasNext()) {
            Address element = it.next();
            if (searchFor.contains(element)) continue;
            it.remove();
            return element;
        }
        return null;
    }

    private DefaultConsistentHash removeLeavers(DefaultConsistentHash baseCH, List<Address> newMembers) {
        int numSegments = baseCH.getNumSegments();
        ArrayList<Address> leavers = new ArrayList<Address>(baseCH.getMembers());
        leavers.removeAll(newMembers);
        boolean segmentsWithZeroOwners = false;
        List[] newSegmentOwners = new List[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            ArrayList<Address> owners = new ArrayList<Address>(baseCH.locateOwnersForSegment(i));
            owners.removeAll(leavers);
            segmentsWithZeroOwners |= owners.isEmpty();
            newSegmentOwners[i] = owners;
        }
        if (segmentsWithZeroOwners) {
            this.assignSegmentsWithZeroOwners(baseCH, newMembers, newSegmentOwners);
        }
        return new DefaultConsistentHash(baseCH.getHashFunction(), numSegments, baseCH.getNumOwners(), newMembers, newSegmentOwners);
    }

    private void assignSegmentsWithZeroOwners(DefaultConsistentHash baseDCH, List<Address> newMembers, List<Address>[] segmentOwners) {
        OwnershipStatistics stats = this.computeStatistics(baseDCH, newMembers);
        int actualNumOwners = Math.min(baseDCH.getNumOwners(), newMembers.size());
        int numSegments = baseDCH.getNumSegments();
        Map<Address, Integer> expectedPrimaryOwnedSegments = this.computeExpectedPrimaryOwned(newMembers, numSegments);
        Map<Address, Integer> expectedOwnedSegments = this.computeExpectedOwned(newMembers, actualNumOwners, numSegments);
        for (int i = 0; i < numSegments; ++i) {
            if (!segmentOwners[i].isEmpty()) continue;
            ArrayList<Address> newOwners = new ArrayList<Address>(actualNumOwners);
            Address primaryOwner = null;
            Iterator<Address> i$ = newMembers.iterator();
            while (i$.hasNext()) {
                Address a;
                primaryOwner = a = i$.next();
                if (stats.getPrimaryOwned(a) >= expectedPrimaryOwnedSegments.get(a)) continue;
                break;
            }
            newOwners.add(primaryOwner);
            stats.incPrimaryOwned(primaryOwner);
            stats.incOwned(primaryOwner);
            if (actualNumOwners > 1) {
                for (Address a : newMembers) {
                    if (stats.getOwned(a) >= expectedOwnedSegments.get(a) || newOwners.contains(a)) continue;
                    newOwners.add(a);
                    stats.incOwned(a);
                    if (newOwners.size() != actualNumOwners) continue;
                    break;
                }
            }
            segmentOwners[i] = newOwners;
        }
    }

    private OwnershipStatistics computeStatistics(DefaultConsistentHash ch, List<Address> nodes) {
        OwnershipStatistics stats = new OwnershipStatistics(nodes);
        for (int i = 0; i < ch.getNumSegments(); ++i) {
            List<Address> owners = ch.locateOwnersForSegment(i);
            for (int j = 0; j < owners.size(); ++j) {
                Address address = owners.get(j);
                if (!nodes.contains(address)) continue;
                if (j == 0) {
                    stats.incPrimaryOwned(address);
                }
                stats.incOwned(address);
            }
        }
        return stats;
    }
}

