/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.remoting.responses.ClusteredGetResponseValidityFilter;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.NotifyingFutureImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReplicationInterceptor
extends BaseRpcInterceptor {
    protected CommandsFactory cf;
    private StateTransferManager stateTransferManager;
    private boolean isPessimisticCache;
    private static final Log log = LogFactory.getLog(ReplicationInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(CommandsFactory cf, StateTransferManager stateTransferManager) {
        this.cf = cf;
        this.stateTransferManager = stateTransferManager;
    }

    @Start
    public void start() {
        this.isPessimisticCache = this.cacheConfiguration.transaction().lockingMode() == LockingMode.PESSIMISTIC;
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!ctx.isInTxScope()) {
            throw new IllegalStateException("This should not be possible!");
        }
        if (ReplicationInterceptor.shouldInvokeRemoteTxCommand(ctx)) {
            this.sendCommitCommand(command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private void sendCommitCommand(CommitCommand command) throws TimeoutException, InterruptedException {
        this.rpcManager.invokeRemotely(null, (ReplicableCommand)command, this.cacheConfiguration.transaction().syncCommitPhase(), true);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (ReplicationInterceptor.shouldInvokeRemoteTxCommand(ctx)) {
            this.broadcastPrepare(ctx, command);
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(this.rpcManager.getTransport().getMembers());
        }
        return retVal;
    }

    protected void broadcastPrepare(TxInvocationContext context, PrepareCommand command) {
        boolean async = this.cacheConfiguration.clustering().cacheMode() == CacheMode.REPL_ASYNC;
        this.rpcManager.broadcastRpcCommand(command, !async, false);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (ReplicationInterceptor.shouldInvokeRemoteTxCommand(ctx) && !Configurations.isOnePhaseCommit(this.cacheConfiguration)) {
            this.rpcManager.broadcastRpcCommand(command, this.cacheConfiguration.transaction().syncRollbackPhase(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            Object returnValue = this.invokeNextInterceptor(ctx, command);
            if (returnValue == null && ctx.isOriginLocal() && this.needsRemoteGet(ctx, command)) {
                returnValue = this.remoteGet(ctx, command, false);
            }
            return returnValue;
        }
        catch (SuspectException e) {
            return this.visitGetKeyValueCommand(ctx, command);
        }
    }

    private boolean needsRemoteGet(InvocationContext ctx, AbstractDataCommand command) {
        CacheEntry entry;
        Object key = command.getKey();
        return !command.hasFlag(Flag.CACHE_MODE_LOCAL) && !command.hasFlag(Flag.SKIP_REMOTE_LOOKUP) && !this.stateTransferManager.getCacheTopology().getReadConsistentHash().isKeyLocalToNode(this.rpcManager.getAddress(), key) && ((entry = ctx.lookupEntry(key)) == null || entry.isNull() || entry.isLockPlaceholder());
    }

    private Object remoteGet(InvocationContext ctx, AbstractDataCommand command, boolean isWrite) throws Throwable {
        Object key = command.getKey();
        if (trace) {
            log.tracef("Key %s is not yet available on %s, so we may need to look elsewhere", key, this.rpcManager.getAddress());
        }
        boolean acquireRemoteLock = false;
        if (ctx.isInTxScope()) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            acquireRemoteLock = isWrite && this.isPessimisticCache && !txContext.getAffectedKeys().contains(key);
        }
        InternalCacheEntry ice = this.retrieveFromRemoteSource(key, ctx, acquireRemoteLock, command.getFlags());
        if (acquireRemoteLock) {
            ((TxInvocationContext)ctx).addAffectedKey(key);
        }
        return ice != null ? ice.getValue() : null;
    }

    private InternalCacheEntry retrieveFromRemoteSource(Object key, InvocationContext ctx, boolean acquireRemoteLock, Set<Flag> flags) {
        GlobalTransaction gtx = acquireRemoteLock ? ((TxInvocationContext)ctx).getGlobalTransaction() : null;
        ClusteredGetCommand get = this.cf.buildClusteredGetCommand(key, flags, acquireRemoteLock, gtx);
        ArrayList<Address> targets = new ArrayList<Address>(this.stateTransferManager.getCacheTopology().getReadConsistentHash().locateOwners(key));
        targets.retainAll(this.rpcManager.getTransport().getMembers());
        ClusteredGetResponseValidityFilter filter = new ClusteredGetResponseValidityFilter(targets, this.rpcManager.getAddress());
        Map<Address, Response> responses = this.rpcManager.invokeRemotely(targets, get, ResponseMode.WAIT_FOR_VALID_RESPONSE, this.cacheConfiguration.clustering().sync().replTimeout(), true, filter);
        if (!responses.isEmpty()) {
            for (Response r : responses.values()) {
                if (!(r instanceof SuccessfulResponse)) continue;
                InternalCacheValue cacheValue = (InternalCacheValue)((SuccessfulResponse)r).getResponseValue();
                return cacheValue.toInternalCacheEntry(key);
            }
        }
        return null;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    private Object handleCrudMethod(InvocationContext ctx, WriteCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!this.isLocalModeForced(command) && command.isSuccessful() && ctx.isOriginLocal() && !ctx.isInTxScope()) {
            if (ctx.isUseFutureReturnType()) {
                NotifyingFutureImpl future = new NotifyingFutureImpl(returnValue);
                this.rpcManager.broadcastRpcCommandInFuture(command, future);
                return future;
            }
            this.rpcManager.broadcastRpcCommand(command, this.isSynchronous(command));
        }
        return returnValue;
    }
}

