/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.InvalidCacheUsageException;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.locking.AbstractTxLockingInterceptor;
import org.infinispan.util.TimSort;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class OptimisticLockingInterceptor
extends AbstractTxLockingInterceptor {
    private LockAcquisitionVisitor lockAcquisitionVisitor;
    private static final MurmurHash3 HASH = new MurmurHash3();
    private boolean needToMarkReads;
    private static final Comparator<Object> keyComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            int anotherVal;
            int thisVal = HASH.hash(o1);
            return thisVal < (anotherVal = HASH.hash(o2)) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    };
    EntryFactory entryFactory;
    private static final Log log = LogFactory.getLog(OptimisticLockingInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void setDependencies(EntryFactory entryFactory) {
        this.entryFactory = entryFactory;
    }

    @Start
    public void start() {
        if (this.cacheConfiguration.clustering().cacheMode() == CacheMode.LOCAL && this.cacheConfiguration.locking().writeSkewCheck() && this.cacheConfiguration.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ && !this.cacheConfiguration.unsafe().unreliableReturnValues()) {
            this.lockAcquisitionVisitor = new LocalWriteSkewCheckingLockAcquisitionVisitor();
            this.needToMarkReads = true;
        } else {
            this.lockAcquisitionVisitor = new LockAcquisitionVisitor();
            this.needToMarkReads = false;
        }
    }

    private void markKeyAsRead(InvocationContext ctx, AbstractDataCommand command) {
        Object key = command.getKey();
        if (this.needToMarkReads && !command.hasFlag(Flag.IGNORE_RETURN_VALUES) && ctx.isInTxScope()) {
            TxInvocationContext tctx = (TxInvocationContext)ctx;
            tctx.getCacheTransaction().addReadKey(key);
        }
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        this.abortIfRemoteTransactionInvalid(ctx, command);
        if (!command.hasModifications() || command.writesToASingleKey()) {
            log.trace("Not using lock reordering as we have a single key.");
            this.acquireLocksVisitingCommands(ctx, command);
        } else {
            boolean hasClear;
            Object[] orderedKeys = this.sort(command.getModifications());
            boolean bl = hasClear = orderedKeys == null;
            if (hasClear) {
                log.trace("Not using lock reordering as the prepare contains a clear command.");
                this.acquireLocksVisitingCommands(ctx, command);
            } else {
                log.tracef("Using lock reordering, order is: %s", orderedKeys);
                this.acquireAllLocks(ctx, orderedKeys);
            }
        }
        return this.invokeNextAndCommitIf1Pc(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        try {
            if (command.isConditional()) {
                this.markKeyAsRead(ctx, command);
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        this.markKeyAsRead(ctx, command);
        return super.visitGetKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        try {
            this.markKeyAsRead(ctx, command);
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        try {
            this.markKeyAsRead(ctx, command);
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        try {
            for (Object key : this.dataContainer.keySet()) {
                this.entryFactory.wrapEntryForClear(ctx, key);
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        throw new InvalidCacheUsageException("Explicit locking is not allowed with optimistic caches!");
    }

    private void performLocalWriteSkewCheck(TxInvocationContext ctx, Object key) {
        CacheEntry ce = ctx.lookupEntry(key);
        if (ce instanceof RepeatableReadEntry && ctx.getCacheTransaction().keyRead(key)) {
            ((RepeatableReadEntry)ce).performLocalWriteSkewCheck(this.dataContainer, true);
        }
    }

    private Object[] sort(WriteCommand[] writes) {
        HashSet<Object> set = new HashSet<Object>();
        block6: for (WriteCommand wc : writes) {
            switch (wc.getCommandId()) {
                case 5: {
                    return null;
                }
                case 8: 
                case 10: 
                case 11: {
                    set.add(((DataWriteCommand)wc).getKey());
                    continue block6;
                }
                case 9: {
                    set.addAll(wc.getAffectedKeys());
                    continue block6;
                }
                case 25: {
                    ApplyDeltaCommand command = (ApplyDeltaCommand)wc;
                    if (!this.cdl.localNodeIsOwner(command.getKey())) continue block6;
                    Object[] compositeKeys = command.getCompositeKeys();
                    set.addAll(Arrays.asList(compositeKeys));
                }
            }
        }
        Object[] sorted = set.toArray(new Object[set.size()]);
        TimSort.sort(sorted, keyComparator);
        return sorted;
    }

    private void acquireAllLocks(TxInvocationContext ctx, Object[] orderedKeys) throws InterruptedException {
        long lockTimeout = this.cacheConfiguration.locking().lockAcquisitionTimeout();
        for (Object key : orderedKeys) {
            this.lockAndRegisterBackupLock(ctx, key, lockTimeout, false);
            this.performLocalWriteSkewCheck(ctx, key);
            ctx.addAffectedKey(key);
        }
    }

    private void acquireLocksVisitingCommands(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        for (WriteCommand wc : command.getModifications()) {
            wc.acceptVisitor(ctx, this.lockAcquisitionVisitor);
        }
    }

    private class LocalWriteSkewCheckingLockAcquisitionVisitor
    extends LockAcquisitionVisitor {
        private LocalWriteSkewCheckingLockAcquisitionVisitor() {
        }

        @Override
        protected void performWriteSkewCheck(TxInvocationContext ctx, Object key) {
            OptimisticLockingInterceptor.this.performLocalWriteSkewCheck(ctx, key);
        }
    }

    private class LockAcquisitionVisitor
    extends AbstractVisitor {
        private LockAcquisitionVisitor() {
        }

        protected void performWriteSkewCheck(TxInvocationContext ctx, Object key) {
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            return this.visitMultiKeyCommand(ctx, command, OptimisticLockingInterceptor.this.dataContainer.keySet());
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            return this.visitMultiKeyCommand(ctx, command, command.getMap().keySet());
        }

        private Object visitMultiKeyCommand(InvocationContext ctx, FlagAffectedCommand command, Set<Object> keys) throws Throwable {
            TxInvocationContext txC = (TxInvocationContext)ctx;
            boolean skipLocking = OptimisticLockingInterceptor.this.hasSkipLocking(command);
            long lockTimeout = OptimisticLockingInterceptor.this.getLockAcquisitionTimeout(command, skipLocking);
            for (Object key : keys) {
                this.lockAndRecord(txC, skipLocking, lockTimeout, key);
            }
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            return this.visitSingleKeyCommand(ctx, command);
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.visitSingleKeyCommand(ctx, command);
        }

        private Object visitSingleKeyCommand(InvocationContext ctx, AbstractDataCommand command) throws InterruptedException {
            TxInvocationContext txC = (TxInvocationContext)ctx;
            boolean skipLocking = OptimisticLockingInterceptor.this.hasSkipLocking(command);
            long lockTimeout = OptimisticLockingInterceptor.this.getLockAcquisitionTimeout(command, skipLocking);
            this.lockAndRecord(txC, skipLocking, lockTimeout, command.getKey());
            return null;
        }

        private void lockAndRecord(TxInvocationContext txC, boolean skipLocking, long lockTimeout, Object key) throws InterruptedException {
            OptimisticLockingInterceptor.this.lockAndRegisterBackupLock(txC, key, lockTimeout, skipLocking);
            this.performWriteSkewCheck(txC, key);
            txC.addAffectedKey(key);
        }

        @Override
        public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
            if (OptimisticLockingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                Object[] compositeKeys = command.getCompositeKeys();
                TxInvocationContext txC = (TxInvocationContext)ctx;
                boolean skipLocking = OptimisticLockingInterceptor.this.hasSkipLocking(command);
                long lockTimeout = OptimisticLockingInterceptor.this.getLockAcquisitionTimeout(command, skipLocking);
                for (Object key : compositeKeys) {
                    this.performWriteSkewCheck(txC, key);
                    OptimisticLockingInterceptor.this.lockAndRegisterBackupLock(txC, key, lockTimeout, skipLocking);
                    txC.addAffectedKey(key);
                }
            }
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return this.visitSingleKeyCommand(ctx, command);
        }
    }
}

