/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheException;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.cache.LoaderConfiguration;
import org.infinispan.configuration.cache.LoadersConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.interceptors.CacheStoreInterceptor;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.decorators.AsyncStore;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.infinispan.loaders.decorators.ReadOnlyStore;
import org.infinispan.loaders.decorators.SingletonStore;
import org.infinispan.loaders.decorators.SingletonStoreConfig;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheLoaderManagerImpl
implements CacheLoaderManager {
    private static final Log log = LogFactory.getLog(CacheLoaderManagerImpl.class);
    Configuration configuration;
    LoadersConfiguration clmConfig;
    AdvancedCache<Object, Object> cache;
    StreamingMarshaller m;
    CacheLoader loader;
    InvocationContextContainer icc;
    TransactionManager transactionManager;
    StateTransferManager stateTransferManager;

    @Inject
    public void inject(AdvancedCache<Object, Object> cache, @ComponentName(value="org.infinispan.marshaller.cache") StreamingMarshaller marshaller, Configuration configuration, InvocationContextContainer icc, TransactionManager transactionManager, StateTransferManager stateTransferManager) {
        this.cache = cache;
        this.m = marshaller;
        this.configuration = configuration;
        this.icc = icc;
        this.transactionManager = transactionManager;
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    public CacheLoader getCacheLoader() {
        return this.loader;
    }

    @Override
    public final CacheStore getCacheStore() {
        if (this.loader != null && this.loader instanceof CacheStore) {
            return (CacheStore)this.loader;
        }
        return null;
    }

    @Override
    public void purge() {
        CacheStore cs = this.getCacheStore();
        if (cs != null) {
            try {
                cs.clear();
            }
            catch (CacheLoaderException e) {
                throw new CacheException("Unable to purge cache store", e);
            }
        }
    }

    private void purgeLoaders(boolean force) throws Exception {
        CacheStore cs = this.getCacheStore();
        if (cs != null) {
            if (cs instanceof ChainingCacheStore && !force) {
                ((ChainingCacheStore)this.loader).purgeIfNecessary();
            } else {
                LoaderConfiguration first = this.clmConfig.cacheLoaders().get(0);
                if (force || first != null && first instanceof StoreConfiguration && ((StoreConfiguration)first).purgeOnStartup()) {
                    cs.clear();
                }
            }
        }
    }

    @Override
    public boolean isUsingPassivation() {
        return this.isEnabled() ? this.clmConfig.passivation() : false;
    }

    @Override
    public boolean isShared() {
        return this.isEnabled() ? this.clmConfig.shared() : false;
    }

    @Override
    public boolean isFetchPersistentState() {
        return this.isEnabled() ? this.clmConfig.fetchPersistentState() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Start(priority=10)
    public void start() {
        this.clmConfig = this.configuration.loaders();
        if (this.clmConfig != null) {
            try {
                this.loader = this.createCacheLoader();
                Transaction xaTx = null;
                if (this.transactionManager != null) {
                    xaTx = this.transactionManager.suspend();
                }
                try {
                    if (this.loader != null) {
                        this.loader.start();
                    }
                }
                finally {
                    if (this.transactionManager != null && xaTx != null) {
                        this.transactionManager.resume(xaTx);
                    }
                }
                this.purgeLoaders(false);
            }
            catch (Exception e) {
                throw new CacheException("Unable to start cache loaders", e);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.clmConfig != null;
    }

    @Override
    public void disableCacheStore(String loaderType) {
        if (this.isEnabled()) {
            boolean disableInterceptors = false;
            ComponentRegistry cr = this.cache.getComponentRegistry();
            CacheLoaderInterceptor cli = cr.getComponent(CacheLoaderInterceptor.class);
            CacheStoreInterceptor csi = cr.getComponent(CacheStoreInterceptor.class);
            if (this.loader instanceof ChainingCacheStore) {
                ChainingCacheStore ccs = (ChainingCacheStore)this.loader;
                ccs.removeCacheLoader(loaderType);
                if (ccs.getStores().isEmpty()) {
                    disableInterceptors = true;
                }
            } else if (this.loader.getClass().getName().equals(loaderType)) {
                try {
                    log.debugf("Stopping and removing cache loader %s", loaderType);
                    this.loader.stop();
                }
                catch (Exception e) {
                    log.infof("Problems shutting down cache loader %s", loaderType, e);
                }
                disableInterceptors = true;
            }
            if (disableInterceptors) {
                cli.disableInterceptor();
                csi.disableInterceptor();
                this.cache.removeInterceptor(cli.getClass());
                this.cache.removeInterceptor(csi.getClass());
                this.clmConfig = null;
            }
        }
    }

    @Override
    @Start(priority=56)
    public void preload() {
        if (this.loader != null && this.clmConfig.preload()) {
            Set<InternalCacheEntry> state;
            if (this.stateTransferManager != null && !this.stateTransferManager.isLocalNodeFirst()) {
                log.debugf("We are not the first node to join cache %s, skipping preload", this.cache.getName());
                return;
            }
            long start = 0L;
            boolean debugTiming = log.isDebugEnabled();
            if (debugTiming) {
                start = System.nanoTime();
                log.debugf("Preloading transient state from cache loader %s", this.loader);
            }
            try {
                state = this.loadState();
            }
            catch (CacheLoaderException e) {
                throw new CacheException("Unable to preload!", e);
            }
            ArrayList<Flag> flags = new ArrayList<Flag>(Arrays.asList(Flag.CACHE_MODE_LOCAL, Flag.SKIP_OWNERSHIP_CHECK, Flag.IGNORE_RETURN_VALUES));
            if (this.clmConfig.shared() || !(this.loader instanceof ChainingCacheStore)) {
                flags.add(Flag.SKIP_CACHE_STORE);
                if (!this.localIndexingEnabled()) {
                    flags.add(Flag.SKIP_INDEXING);
                }
            } else {
                flags.add(Flag.SKIP_INDEXING);
            }
            AdvancedCache<Object, Object> flaggedCache = this.cache.getAdvancedCache().withFlags(flags.toArray(new Flag[0]));
            for (InternalCacheEntry e : state) {
                flaggedCache.putIfAbsent(e.getKey(), e.getValue(), e.getLifespan(), TimeUnit.MILLISECONDS, e.getMaxIdle(), TimeUnit.MILLISECONDS);
            }
            if (debugTiming) {
                long stop = System.nanoTime();
                log.debugf("Preloaded %s keys in %s", state.size(), Util.prettyPrintTime(stop - start, TimeUnit.NANOSECONDS));
            }
        }
    }

    private boolean localIndexingEnabled() {
        return this.configuration.indexing().enabled() && this.configuration.indexing().indexLocalOnly();
    }

    private Set<InternalCacheEntry> loadState() throws CacheLoaderException {
        Set<InternalCacheEntry> state;
        int ne = -1;
        if (this.configuration.eviction().strategy().isEnabled()) {
            ne = this.configuration.eviction().maxEntries();
        }
        switch (ne) {
            case -1: {
                state = this.loader.loadAll();
                break;
            }
            case 0: {
                state = Collections.emptySet();
                break;
            }
            default: {
                state = this.loader.load(ne);
            }
        }
        return state;
    }

    @Override
    @Stop
    public void stop() {
        if (this.loader != null) {
            try {
                this.loader.stop();
            }
            catch (CacheLoaderException e) {
                throw new CacheException(e);
            }
            finally {
                this.loader = null;
            }
        }
    }

    CacheLoader createCacheLoader() throws Exception {
        CacheLoader tmpLoader;
        if (this.clmConfig.usingChainingCacheLoader()) {
            ChainingCacheStore ccl;
            tmpLoader = ccl = new ChainingCacheStore();
            int numLoadersWithFetchPersistentState = 0;
            for (LoaderConfiguration cfg : this.clmConfig.cacheLoaders()) {
                if (cfg instanceof StoreConfiguration) {
                    StoreConfiguration scfg = (StoreConfiguration)cfg;
                    this.assertNotSingletonAndShared(scfg);
                    if (scfg.fetchPersistentState()) {
                        ++numLoadersWithFetchPersistentState;
                    }
                }
                if (numLoadersWithFetchPersistentState > 1) {
                    throw new Exception("Invalid cache loader configuration!!  Only ONE cache loader may have fetchPersistentState set to true.  Cache will not start!");
                }
                CacheLoader l = this.createCacheLoader(LegacyConfigurationAdaptor.adapt(cfg), this.cache);
                ccl.addCacheLoader(l, cfg);
            }
        } else if (!this.clmConfig.cacheLoaders().isEmpty()) {
            LoaderConfiguration cfg = this.clmConfig.cacheLoaders().get(0);
            if (cfg instanceof StoreConfiguration) {
                this.assertNotSingletonAndShared((StoreConfiguration)cfg);
            }
            tmpLoader = this.createCacheLoader(LegacyConfigurationAdaptor.adapt(cfg), this.cache);
        } else {
            return null;
        }
        return tmpLoader;
    }

    CacheLoader createCacheLoader(CacheLoaderConfig cfg, AdvancedCache<Object, Object> cache) throws Exception {
        CacheLoader tmpLoader = (CacheLoader)Util.getInstance(cfg.getCacheLoaderClassName(), cache.getClassLoader());
        if (tmpLoader != null) {
            if (cfg instanceof CacheStoreConfig) {
                SingletonStoreConfig ssc;
                CacheStore tmpStore = (CacheStore)tmpLoader;
                CacheStoreConfig cfg2 = (CacheStoreConfig)cfg;
                if (cfg2.getAsyncStoreConfig().isEnabled().booleanValue()) {
                    tmpStore = this.createAsyncStore(tmpStore, cfg2);
                    tmpLoader = tmpStore;
                }
                if (cfg2.isIgnoreModifications().booleanValue()) {
                    tmpStore = new ReadOnlyStore(tmpStore);
                    tmpLoader = tmpStore;
                }
                if ((ssc = cfg2.getSingletonStoreConfig()) != null && ssc.isSingletonStoreEnabled().booleanValue()) {
                    tmpStore = new SingletonStore(tmpStore, cache, ssc);
                    tmpLoader = tmpStore;
                }
            }
            tmpLoader.init(cfg, cache, this.m);
        }
        return tmpLoader;
    }

    protected AsyncStore createAsyncStore(CacheStore tmpStore, CacheStoreConfig cfg2) {
        return new AsyncStore(tmpStore, cfg2.getAsyncStoreConfig());
    }

    void assertNotSingletonAndShared(StoreConfiguration cfg) {
        if (cfg.singletonStore().enabled() && this.clmConfig.shared()) {
            throw new ConfigurationException("Invalid cache loader configuration!!  If a cache loader is configured as a singleton, the cache loader cannot be shared in a cluster!");
        }
    }
}

