/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;

public class JGroupsBackupResponse
implements BackupResponse {
    private static Log log = LogFactory.getLog(JGroupsBackupResponse.class);
    private final Map<XSiteBackup, Future<Object>> syncBackupCalls;
    private Map<String, Exception> errors;
    private long sendTimeNanos;

    public JGroupsBackupResponse(Map<XSiteBackup, Future<Object>> syncBackupCalls) {
        this.syncBackupCalls = syncBackupCalls;
        this.sendTimeNanos = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForBackupToFinish() throws Exception {
        long deductFromTimeout = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.sendTimeNanos);
        this.errors = new HashMap<String, Exception>(this.syncBackupCalls.size());
        long elapsedTime = 0L;
        for (Map.Entry<XSiteBackup, Future<Object>> entry : this.syncBackupCalls.entrySet()) {
            long timeout = entry.getKey().getTimeout();
            String siteName = entry.getKey().getSiteName();
            if (timeout > 0L) {
                timeout -= deductFromTimeout;
                if ((timeout -= elapsedTime) <= 0L && !entry.getValue().isDone()) {
                    this.errors.put(siteName, this.newTimeoutException(entry, entry.getKey().getTimeout()));
                }
            }
            long startNanos = System.nanoTime();
            Object value = null;
            try {
                value = entry.getValue().get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException te) {
                this.errors.put(siteName, this.newTimeoutException(entry, entry.getKey().getTimeout()));
            }
            finally {
                elapsedTime += TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            }
            if (value instanceof ExceptionResponse) {
                Exception remoteException = ((ExceptionResponse)value).getException();
                log.tracef(remoteException, "Got error backup response from site %s", siteName);
                this.errors.put(siteName, remoteException);
                continue;
            }
            log.tracef("Received response from site %s: %s", siteName, value);
        }
    }

    @Override
    public Map<String, Exception> getFailedBackups() {
        return this.errors;
    }

    private TimeoutException newTimeoutException(Map.Entry<XSiteBackup, Future<Object>> entry, long timeout) {
        return new TimeoutException(Util.formatString("Timed out after %s waiting for a response from %s", Util.prettyPrintTime(timeout), entry.getKey()));
    }
}

