/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferLockImpl
implements StateTransferLock {
    private static final Log log = LogFactory.getLog(StateTransferLockImpl.class);
    private final ReadWriteLock transactionTableLock = new ReentrantReadWriteLock();
    private final ReadWriteLock commandLock = new ReentrantReadWriteLock();
    private volatile int topologyId;
    private final Object topologyLock = new Object();

    @Override
    public void transactionsSharedLock() {
        this.transactionTableLock.readLock().lock();
    }

    @Override
    public void transactionsSharedUnlock() {
        this.transactionTableLock.readLock().unlock();
    }

    @Override
    public void transactionsExclusiveLock() {
        this.transactionTableLock.writeLock().lock();
    }

    @Override
    public void transactionsExclusiveUnlock() {
        this.transactionTableLock.writeLock().unlock();
    }

    @Override
    public void commandsExclusiveLock() {
        this.commandLock.writeLock().lock();
    }

    @Override
    public void commandsExclusiveUnlock() {
        this.commandLock.writeLock().unlock();
    }

    @Override
    public void commandsSharedLock() {
        this.commandLock.readLock().lock();
    }

    @Override
    public void commandsSharedUnlock() {
        this.commandLock.readLock().unlock();
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
        Object object = this.topologyLock;
        synchronized (object) {
            this.topologyLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForTopology(int expectedTopologyId) throws InterruptedException {
        if (this.topologyId >= expectedTopologyId) {
            return;
        }
        log.tracef("Waiting for topology %d to be installed, current topology is %d", expectedTopologyId, this.topologyId);
        Object object = this.topologyLock;
        synchronized (object) {
            while (this.topologyId < expectedTopologyId) {
                this.topologyLock.wait();
            }
        }
    }
}

