/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import org.infinispan.CacheException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheTopologyControlCommand
implements ReplicableCommand {
    private static final Log log = LogFactory.getLog(CacheTopologyControlCommand.class);
    public static final byte COMMAND_ID = 17;
    private transient LocalTopologyManager localTopologyManager;
    private transient ClusterTopologyManager clusterTopologyManager;
    private String cacheName;
    private Type type;
    private Address sender;
    private CacheJoinInfo joinInfo;
    private int topologyId;
    private ConsistentHash currentCH;
    private ConsistentHash pendingCH;
    private Throwable throwable;
    private int viewId;

    public CacheTopologyControlCommand() {
        this.cacheName = null;
    }

    public CacheTopologyControlCommand(String cacheName, Type type, Address sender, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.viewId = viewId;
    }

    public CacheTopologyControlCommand(String cacheName, Type type, Address sender, CacheJoinInfo joinInfo, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.joinInfo = joinInfo;
        this.viewId = viewId;
    }

    public CacheTopologyControlCommand(String cacheName, Type type, Address sender, int topologyId, Throwable throwable, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.topologyId = topologyId;
        this.throwable = throwable;
        this.viewId = viewId;
    }

    public CacheTopologyControlCommand(String cacheName, Type type, Address sender, CacheTopology cacheTopology, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.viewId = viewId;
        this.topologyId = cacheTopology.getTopologyId();
        this.currentCH = cacheTopology.getCurrentCH();
        this.pendingCH = cacheTopology.getPendingCH();
    }

    @Inject
    public void init(LocalTopologyManager localTopologyManager, ClusterTopologyManager globalDistributionManager) {
        this.localTopologyManager = localTopologyManager;
        this.clusterTopologyManager = globalDistributionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(this.cacheName, trace);
        try {
            Object responseValue = this.doPerform();
            SuccessfulResponse successfulResponse = SuccessfulResponse.create(responseValue);
            return successfulResponse;
        }
        catch (InterruptedException e) {
            log.tracef("Command execution %s was interrupted because the cache manager is shutting down", this);
            UnsuccessfulResponse unsuccessfulResponse = UnsuccessfulResponse.INSTANCE;
            return unsuccessfulResponse;
        }
        catch (Exception t) {
            log.exceptionHandlingCommand(this, t);
            ExceptionResponse exceptionResponse = new ExceptionResponse(t);
            return exceptionResponse;
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    private Object doPerform() throws Exception {
        switch (this.type) {
            case JOIN: {
                return this.clusterTopologyManager.handleJoin(this.cacheName, this.sender, this.joinInfo, this.viewId);
            }
            case LEAVE: {
                this.clusterTopologyManager.handleLeave(this.cacheName, this.sender, this.viewId);
                return null;
            }
            case REBALANCE_CONFIRM: {
                this.clusterTopologyManager.handleRebalanceCompleted(this.cacheName, this.sender, this.topologyId, this.throwable, this.viewId);
                return null;
            }
            case CH_UPDATE: {
                this.localTopologyManager.handleConsistentHashUpdate(this.cacheName, new CacheTopology(this.topologyId, this.currentCH, this.pendingCH), this.viewId);
                return null;
            }
            case REBALANCE_START: {
                this.localTopologyManager.handleRebalance(this.cacheName, new CacheTopology(this.topologyId, this.currentCH, this.pendingCH), this.viewId);
                return null;
            }
            case GET_STATUS: {
                return this.localTopologyManager.handleStatusRequest(this.viewId);
            }
        }
        throw new CacheException("Unknown cache topology control command type " + (Object)((Object)this.type));
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Address getOrigin() {
        return this.sender;
    }

    public Type getType() {
        return this.type;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    public ConsistentHash getCurrentCH() {
        return this.currentCH;
    }

    public ConsistentHash getPendingCH() {
        return this.pendingCH;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public byte getCommandId() {
        return 17;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.cacheName, (byte)this.type.ordinal(), this.sender, this.joinInfo, this.topologyId, this.currentCH, this.pendingCH, this.throwable, this.viewId};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        int i = 0;
        this.cacheName = (String)parameters[i++];
        this.type = Type.values()[(Byte)parameters[i++]];
        this.sender = (Address)parameters[i++];
        this.joinInfo = (CacheJoinInfo)parameters[i++];
        this.topologyId = (Integer)parameters[i++];
        this.currentCH = (ConsistentHash)parameters[i++];
        this.pendingCH = (ConsistentHash)parameters[i++];
        this.throwable = (Throwable)parameters[i++];
        this.viewId = (Integer)parameters[i++];
    }

    public String toString() {
        return "CacheTopologyControlCommand{cache=" + this.cacheName + ", type=" + (Object)((Object)this.type) + ", sender=" + this.sender + ", joinInfo=" + this.joinInfo + ", topologyId=" + this.topologyId + ", currentCH=" + this.currentCH + ", pendingCH=" + this.pendingCH + ", throwable=" + this.throwable + ", viewId=" + this.viewId + '}';
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    public static enum Type {
        JOIN,
        LEAVE,
        REBALANCE_CONFIRM,
        CH_UPDATE,
        REBALANCE_START,
        GET_STATUS;

    }
}

