/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class BackupReceiver {
    private final Cache cache;
    private final ConcurrentMap<GlobalTransaction, GlobalTransaction> remote2localTx = new ConcurrentHashMap<GlobalTransaction, GlobalTransaction>();
    private final BackupCacheUpdater siteUpdater;

    public BackupReceiver(Cache cache) {
        this.cache = cache;
        this.siteUpdater = new BackupCacheUpdater(cache, this.remote2localTx);
    }

    public Cache getCache() {
        return this.cache;
    }

    public Object handleRemoteCommand(VisitableCommand command) throws Throwable {
        return command.acceptVisitor(null, this.siteUpdater);
    }

    public static final class BackupCacheUpdater
    extends AbstractVisitor {
        private static Log log = LogFactory.getLog(BackupCacheUpdater.class);
        private final ConcurrentMap<GlobalTransaction, GlobalTransaction> remote2localTx;
        private final AdvancedCache backupCache;

        BackupCacheUpdater(Cache backup, ConcurrentMap<GlobalTransaction, GlobalTransaction> remote2localTx) {
            this.backupCache = backup.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES, Flag.SKIP_XSITE_BACKUP);
            this.remote2localTx = remote2localTx;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            log.tracef("Processing a remote put %s", command);
            if (command.isConditional()) {
                return this.backupCache.putIfAbsent(command.getKey(), command.getValue(), command.getLifespanMillis(), TimeUnit.MILLISECONDS, command.getMaxIdleTimeMillis(), TimeUnit.MILLISECONDS);
            }
            return this.backupCache.put(command.getKey(), command.getValue(), command.getLifespanMillis(), TimeUnit.MILLISECONDS, command.getMaxIdleTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            if (command.isConditional()) {
                return this.backupCache.remove(command.getKey(), command.getValue());
            }
            return this.backupCache.remove(command.getKey());
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            if (command.isConditional() && command.getOldValue() != null) {
                return this.backupCache.replace(command.getKey(), command.getOldValue(), command.getNewValue(), command.getLifespanMillis(), TimeUnit.MILLISECONDS, command.getMaxIdleTimeMillis(), TimeUnit.MILLISECONDS);
            }
            return this.backupCache.replace(command.getKey(), command.getNewValue(), command.getLifespanMillis(), TimeUnit.MILLISECONDS, command.getMaxIdleTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            this.backupCache.putAll(command.getMap(), command.getLifespanMillis(), TimeUnit.MILLISECONDS, command.getMaxIdleTimeMillis(), TimeUnit.MILLISECONDS);
            return null;
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            this.backupCache.clear();
            return null;
        }

        @Override
        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            boolean isTransactional = this.isTransactional();
            if (isTransactional) {
                this.replayModificationsInTransaction(command, command.isOnePhaseCommit());
            } else {
                this.replayModifications(command);
            }
            return null;
        }

        private boolean isTransactional() {
            return this.backupCache.getCacheConfiguration().transaction().transactionMode() == TransactionMode.TRANSACTIONAL;
        }

        @Override
        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            if (!this.isTransactional()) {
                log.cannotRespondToRollback(command.getGlobalTransaction(), this.backupCache.getName());
            } else {
                log.tracef("Rolling back remote transaction %s", command.getGlobalTransaction());
                this.completeTransaction(command.getGlobalTransaction(), true);
            }
            return null;
        }

        @Override
        public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
            this.completeTransaction(command.getGlobalTransaction(), false);
            return null;
        }

        private void completeTransaction(GlobalTransaction globalTransaction, boolean commit) throws Throwable {
            TransactionTable txTable = this.txTable();
            GlobalTransaction localTxId = (GlobalTransaction)this.remote2localTx.remove(globalTransaction);
            if (localTxId == null) {
                throw new CacheException("Couldn't find a local transaction corresponding to remote transaction " + globalTransaction);
            }
            LocalTransaction localTx = txTable.getLocalTransaction(localTxId);
            if (localTx == null) {
                throw new IllegalStateException("Local tx not found but present in the tx table!");
            }
            TransactionManager txManager = this.txManager();
            txManager.resume(localTx.getTransaction());
            if (commit) {
                txManager.commit();
            } else {
                txManager.rollback();
            }
        }

        private void replayModificationsInTransaction(PrepareCommand command, boolean onePhaseCommit) throws Throwable {
            TransactionManager tm = this.txManager();
            tm.begin();
            this.replayModifications(command);
            LocalTransaction localTx = this.txTable().getLocalTransaction(tm.getTransaction());
            localTx.setFromRemoteSite(true);
            if (onePhaseCommit) {
                log.tracef("Committing remotely originated tx %s as it is 1PC", command.getGlobalTransaction());
                tm.commit();
            } else {
                this.remote2localTx.put(command.getGlobalTransaction(), localTx.getGlobalTransaction());
            }
            tm.suspend();
        }

        private TransactionManager txManager() {
            return this.backupCache.getAdvancedCache().getTransactionManager();
        }

        public TransactionTable txTable() {
            return this.backupCache.getComponentRegistry().getComponent(TransactionTable.class);
        }

        private void replayModifications(PrepareCommand command) throws Throwable {
            for (WriteCommand c : command.getModifications()) {
                c.acceptVisitor(null, this);
            }
        }
    }
}

