/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.BackupReceiverRepository;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteUUID;

public class BackupReceiverRepositoryImpl
implements BackupReceiverRepository {
    private static Log log = LogFactory.getLog(BackupReceiverRepositoryImpl.class);
    public static final ConcurrentMap<SiteCachePair, BackupReceiver> backupReceivers = new ConcurrentHashMap<SiteCachePair, BackupReceiver>();
    public EmbeddedCacheManager cacheManager;

    @Inject
    public void setup(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public Object handleRemoteCommand(SingleRpcCommand cmd, SiteAddress src) throws Throwable {
        log.tracef("Handling command %s from remote site %s", cmd, src);
        String name = cmd.getCacheName();
        BackupReceiver localBackupCache = this.getBackupCacheManager(SiteUUID.getSiteName((short)src.getSite()), name);
        return localBackupCache.handleRemoteCommand((VisitableCommand)cmd.getCommand());
    }

    private BackupReceiver getBackupCacheManager(String remoteSite, String remoteCache) {
        SiteCachePair toLookFor = new SiteCachePair(remoteCache, remoteSite);
        BackupReceiver backupManager = (BackupReceiver)backupReceivers.get(toLookFor);
        if (backupManager != null) {
            return backupManager;
        }
        Configuration dcc = this.cacheManager.getDefaultCacheConfiguration();
        if (this.isBackupForRemoteCache(remoteSite, remoteCache, dcc, "___defaultcache")) {
            Cache cache = this.cacheManager.getCache();
            backupReceivers.putIfAbsent(toLookFor, new BackupReceiver(cache));
            return (BackupReceiver)backupReceivers.get(toLookFor);
        }
        Set<String> cacheNames = this.cacheManager.getCacheNames();
        for (String name : cacheNames) {
            Configuration cacheConfiguration = this.cacheManager.getCacheConfiguration(name);
            if (!this.isBackupForRemoteCache(remoteSite, remoteCache, cacheConfiguration, name)) continue;
            Cache cache = this.cacheManager.getCache(name);
            backupReceivers.putIfAbsent(toLookFor, new BackupReceiver(cache));
            return (BackupReceiver)backupReceivers.get(toLookFor);
        }
        log.debugf("Did not find any backup explicitly configured backup cache for remote cache/site: %s/%s. Using %s", remoteSite, remoteCache, remoteCache);
        Cache cache = this.cacheManager.getCache(remoteCache);
        backupReceivers.putIfAbsent(toLookFor, new BackupReceiver(cache));
        return (BackupReceiver)backupReceivers.get(toLookFor);
    }

    private boolean isBackupForRemoteCache(String remoteSite, String remoteCache, Configuration cacheConfiguration, String name) {
        boolean found = cacheConfiguration.sites().backupFor().isBackupFor(remoteSite, remoteCache);
        if (found) {
            log.tracef("Found local cache '%s' is backup for cache '%s' from site '%s'", name, remoteCache, remoteSite);
        }
        return found;
    }

    static class SiteCachePair {
        public final String site;
        public final String cache;

        SiteCachePair(String cache, String site) {
            this.cache = cache;
            this.site = site;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SiteCachePair)) {
                return false;
            }
            SiteCachePair that = (SiteCachePair)o;
            if (this.cache != null ? !this.cache.equals(that.cache) : that.cache != null) {
                return false;
            }
            return !(this.site != null ? !this.site.equals(that.site) : that.site != null);
        }

        public int hashCode() {
            int result = this.site != null ? this.site.hashCode() : 0;
            result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "SiteCachePair{site='" + this.site + '\'' + ", cache='" + this.cache + '\'' + '}';
        }
    }
}

