/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupFailureException;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.CustomFailurePolicy;
import org.infinispan.xsite.XSiteBackup;

public class BackupSenderImpl
implements BackupSender {
    private static Log log = LogFactory.getLog(BackupSenderImpl.class);
    private Cache cache;
    private Transport transport;
    private Configuration config;
    private TransactionTable txTable;
    private final Map<String, CustomFailurePolicy> siteFailurePolicy = new HashMap<String, CustomFailurePolicy>();
    private final String localSiteName;
    private String cacheName;
    private GlobalConfiguration globalConfig;

    public BackupSenderImpl(String localSiteName) {
        this.localSiteName = localSiteName;
    }

    @Inject
    public void init(Cache cache, Transport transport, TransactionTable txTable, GlobalConfiguration gc) {
        this.cache = cache;
        this.transport = transport;
        this.txTable = txTable;
        this.globalConfig = gc;
    }

    @Start
    public void start() {
        this.config = this.cache.getCacheConfiguration();
        this.cacheName = this.cache.getName();
        for (BackupConfiguration bc : this.config.sites().backups()) {
            if (bc.backupFailurePolicy() != BackupFailurePolicy.CUSTOM) continue;
            String backupPolicy = bc.failurePolicyClass();
            if (backupPolicy == null) {
                throw new IllegalStateException("Backup policy class missing for custom failure policy!");
            }
            CustomFailurePolicy instance = (CustomFailurePolicy)Util.getInstance(backupPolicy, this.globalConfig.classLoader());
            this.siteFailurePolicy.put(bc.site(), instance);
        }
    }

    @Override
    public BackupResponse backupPrepare(PrepareCommand command) throws Exception {
        BackupFilter filter = !command.isOnePhaseCommit() ? BackupFilter.KEEP_SYNC_ONLY : BackupFilter.KEEP_ALL;
        List<XSiteBackup> backups = this.calculateBackupInfo(filter);
        return this.backupCommand(command, backups);
    }

    @Override
    public void processResponses(BackupResponse backupResponse, VisitableCommand command) throws Throwable {
        this.processResponses(backupResponse, command, null);
    }

    @Override
    public void processResponses(BackupResponse backupResponse, VisitableCommand command, Transaction transaction) throws Throwable {
        backupResponse.waitForBackupToFinish();
        SitesConfiguration sitesConfiguration = this.config.sites();
        Map<String, Exception> failures = backupResponse.getFailedBackups();
        for (Map.Entry<String, Exception> failure : failures.entrySet()) {
            BackupFailurePolicy policy = sitesConfiguration.getFailurePolicy(failure.getKey());
            if (policy == BackupFailurePolicy.CUSTOM) {
                CustomFailurePolicy customFailurePolicy = this.siteFailurePolicy.get(failure.getKey());
                command.acceptVisitor(null, new CustomBackupPolicyInvoker(failure.getKey(), customFailurePolicy, transaction));
            }
            if (policy == BackupFailurePolicy.WARN) {
                log.warnXsiteBackupFailed(this.cacheName, failure.getKey(), failure.getValue());
                continue;
            }
            if (policy != BackupFailurePolicy.FAIL) continue;
            throw new BackupFailureException(failure.getValue(), failure.getKey(), this.cacheName);
        }
    }

    @Override
    public BackupResponse backupWrite(WriteCommand command) throws Exception {
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_ALL);
        return this.backupCommand(command, xSiteBackups);
    }

    @Override
    public BackupResponse backupCommit(CommitCommand command) throws Exception {
        this.send1PcToAsyncBackups(command);
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_SYNC_ONLY);
        return this.backupCommand(command, xSiteBackups);
    }

    @Override
    public BackupResponse backupRollback(RollbackCommand command) throws Exception {
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_SYNC_ONLY);
        return this.backupCommand(command, xSiteBackups);
    }

    private BackupResponse backupCommand(ReplicableCommand command, List<XSiteBackup> xSiteBackups) throws Exception {
        return this.transport.backupRemotely(xSiteBackups, new SingleRpcCommand(this.cacheName, command));
    }

    private void send1PcToAsyncBackups(CommitCommand command) throws Exception {
        List<XSiteBackup> backups = this.calculateBackupInfo(BackupFilter.KEEP_ASYNC_ONLY);
        LocalTransaction localTx = this.txTable.getLocalTransaction(command.getGlobalTransaction());
        PrepareCommand prepare = new PrepareCommand(this.cacheName, localTx.getGlobalTransaction(), localTx.getModifications(), true);
        this.backupCommand(prepare, backups);
    }

    private List<XSiteBackup> calculateBackupInfo(BackupFilter backupFilter) {
        ArrayList<XSiteBackup> backupInfo = new ArrayList<XSiteBackup>(2);
        SitesConfiguration sites = this.config.sites();
        for (BackupConfiguration bc : sites.backups()) {
            boolean isSync;
            if (bc.site().equals(this.localSiteName)) {
                log.cacheBackupsDataToSameSite(this.localSiteName);
                continue;
            }
            boolean bl = isSync = bc.strategy() == BackupConfiguration.BackupStrategy.SYNC;
            if (backupFilter == BackupFilter.KEEP_ASYNC_ONLY && isSync || backupFilter == BackupFilter.KEEP_SYNC_ONLY && !isSync) continue;
            XSiteBackup bi = new XSiteBackup(bc.site(), isSync, bc.replicationTimeout());
            backupInfo.add(bi);
        }
        return backupInfo;
    }

    public static final class CustomBackupPolicyInvoker
    extends AbstractVisitor {
        private final String site;
        private final CustomFailurePolicy failurePolicy;
        private final Transaction tx;

        public CustomBackupPolicyInvoker(String site, CustomFailurePolicy failurePolicy, Transaction tx) {
            this.site = site;
            this.failurePolicy = failurePolicy;
            this.tx = tx;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            this.failurePolicy.handlePutFailure(this.site, command.getKey(), command.getValue(), command.isPutIfAbsent());
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            this.failurePolicy.handleRemoveFailure(this.site, command.getKey(), command.getValue());
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            this.failurePolicy.handleReplaceFailure(this.site, command.getKey(), command.getOldValue(), command.getNewValue());
            return null;
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            this.failurePolicy.handleClearFailure(this.site);
            return null;
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            this.failurePolicy.handlePutAllFailure(this.site, command.getMap());
            return null;
        }

        @Override
        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            this.failurePolicy.handlePrepareFailure(this.site, this.tx);
            return null;
        }

        @Override
        public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
            this.failurePolicy.handleRollbackFailure(this.site, this.tx);
            return null;
        }

        @Override
        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            this.failurePolicy.handleCommitFailure(this.site, this.tx);
            return null;
        }

        @Override
        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            super.handleDefault(ctx, command);
            throw new IllegalStateException("Unknown command: " + command);
        }
    }

    static enum BackupFilter {
        KEEP_SYNC_ONLY,
        KEEP_ASYNC_ONLY,
        KEEP_ALL;

    }
}

