/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.as;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EnumSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.as.Attribute;
import org.infinispan.configuration.as.Element;
import org.infinispan.configuration.as.Mode;
import org.infinispan.configuration.as.NetworkInterface;
import org.infinispan.configuration.as.OutboundSocketBinding;
import org.infinispan.configuration.as.ParserContextAS7;
import org.infinispan.configuration.as.SocketBinding;
import org.infinispan.configuration.as.SocketBindingGroup;
import org.infinispan.configuration.as.TransactionMode;
import org.infinispan.configuration.cache.AsyncStoreConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.StringPropertyReplacer;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ParserAS7
implements ConfigurationParser<ConfigurationBuilderHolder> {
    public static final String URN_JBOSS_DOMAIN = "urn:jboss:domain";
    public static final String URN_JBOSS_DOMAIN_INFINISPAN = "urn:jboss:domain:infinispan";
    private static final Namespace[] NAMESPACES = new Namespace[]{new Namespace("urn:jboss:domain", Element.ROOT.getLocalName(), 1, 4), new Namespace("urn:jboss:domain", Element.ROOT.getLocalName(), 1, 3)};

    @Override
    public Namespace[] getSupportedNamespaces() {
        return NAMESPACES;
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        holder.setParserContext(ParserAS7.class, new ParserContextAS7());
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROFILE: {
                    this.parseProfile(reader, holder);
                    continue block5;
                }
                case INTERFACES: {
                    this.parseInterfaces(reader, holder);
                    continue block5;
                }
                case SOCKET_BINDING_GROUP: {
                    this.parseSocketBindingGroup(reader, holder);
                    continue block5;
                }
            }
            reader.discardRemainder();
        }
    }

    private void parseProfile(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SUBSYSTEM: {
                    String ns = reader.getNamespaceURI();
                    if (ns.contains("jgroups")) {
                        this.parseJGroupsSubsystem(reader, holder);
                        continue block3;
                    }
                    if (ns.contains("threads")) {
                        this.parseThreadsSubsystem(reader, holder);
                        continue block3;
                    }
                    if (ns.contains("infinispan")) {
                        this.parseInfinispanSubsystem(reader, holder);
                        continue block3;
                    }
                    reader.discardRemainder();
                    continue block3;
                }
            }
            reader.discardRemainder();
        }
    }

    private void parseThreadsSubsystem(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case THREAD_FACTORY: {
                    this.parseThreadFactory(reader, holder);
                    continue block8;
                }
                case UNBOUNDED_QUEUE_THREAD_POOL: {
                    reader.discardRemainder();
                    continue block8;
                }
                case BOUNDED_QUEUE_THREAD_POOL: {
                    reader.discardRemainder();
                    continue block8;
                }
                case BLOCKING_BOUNDED_QUEUE_THREAD_POOL: {
                    reader.discardRemainder();
                    continue block8;
                }
                case QUEUELESS_THREAD_POOL: {
                    reader.discardRemainder();
                    continue block8;
                }
                case SCHEDULED_THREAD_POOL: {
                    reader.discardRemainder();
                    continue block8;
                }
            }
            ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseThreadFactory(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        reader.discardRemainder();
    }

    private void parseJGroupsSubsystem(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        reader.discardRemainder();
    }

    private void parseInfinispanSubsystem(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CACHE_CONTAINER: {
                    this.parseContainer(reader, holder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseContainer(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block15: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ALIASES: 
                case JNDI_NAME: 
                case NAME: 
                case START: {
                    continue block15;
                }
                case DEFAULT_CACHE: {
                    continue block15;
                }
                case LISTENER_EXECUTOR: {
                    continue block15;
                }
                case EVICTION_EXECUTOR: {
                    continue block15;
                }
                case REPLICATION_QUEUE_EXECUTOR: {
                    continue block15;
                }
                case MODULE: {
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TRANSPORT: {
                    this.parseTransport(reader, holder);
                    continue block16;
                }
                case LOCAL_CACHE: {
                    this.parseLocalCache(reader, holder);
                    continue block16;
                }
                case INVALIDATION_CACHE: {
                    this.parseInvalidationCache(reader, holder);
                    continue block16;
                }
                case REPLICATED_CACHE: {
                    this.parseReplicatedCache(reader, holder);
                    continue block16;
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(reader, holder);
                    continue block16;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    protected void parseCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ConfigurationBuilder builder) throws XMLStreamException {
        switch (attribute) {
            case JNDI_NAME: 
            case NAME: 
            case START: {
                break;
            }
            case BATCHING: {
                builder.invocationBatching().enable();
                break;
            }
            case INDEXING: {
                builder.indexing().enable();
                break;
            }
            case MODULE: {
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, index);
            }
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STACK: {
                    continue block6;
                }
                case CLUSTER: {
                    continue block6;
                }
                case EXECUTOR: {
                    continue block6;
                }
                case LOCK_TIMEOUT: {
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseClusteredCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ConfigurationBuilder builder, CacheMode cacheMode) throws XMLStreamException {
        switch (attribute) {
            case ASYNC_MARSHALLING: {
                builder.clustering().async().asyncMarshalling(Boolean.parseBoolean(value));
                break;
            }
            case MODE: {
                Mode mode = Mode.valueOf(value);
                builder.clustering().cacheMode(mode.apply(cacheMode));
                break;
            }
            case QUEUE_SIZE: {
                builder.clustering().async().replQueueMaxElements(Integer.parseInt(value));
                break;
            }
            case QUEUE_FLUSH_INTERVAL: {
                builder.clustering().async().replQueueInterval(Long.parseLong(value));
                break;
            }
            case REMOTE_TIMEOUT: {
                builder.clustering().sync().replTimeout(Long.parseLong(value));
                break;
            }
            default: {
                this.parseCacheAttribute(reader, index, attribute, value, builder);
            }
        }
    }

    private void parseLocalCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        ConfigurationBuilder builder = holder.newConfigurationBuilder(name);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseCacheAttribute(reader, i, attribute, value, builder);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            this.parseCacheElement(reader, element, holder);
        }
    }

    private void parseDistributedCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        ConfigurationBuilder builder = holder.newConfigurationBuilder(name);
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OWNERS: {
                    builder.clustering().hash().numOwners(Integer.parseInt(value));
                    continue block8;
                }
                case VIRTUAL_NODES: {
                    builder.clustering().hash().numVirtualNodes(Integer.parseInt(value));
                    continue block8;
                }
                case L1_LIFESPAN: {
                    builder.clustering().l1().lifespan(Long.parseLong(value));
                    continue block8;
                }
                default: {
                    this.parseClusteredCacheAttribute(reader, i, attribute, value, builder, CacheMode.DIST_ASYNC);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, builder);
                    continue block9;
                }
            }
            this.parseCacheElement(reader, element, holder);
        }
    }

    private void parseReplicatedCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        ConfigurationBuilder builder = holder.newConfigurationBuilder(name);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseClusteredCacheAttribute(reader, i, attribute, value, builder, CacheMode.REPL_ASYNC);
        }
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, builder);
                    continue block4;
                }
            }
            this.parseCacheElement(reader, element, holder);
        }
    }

    private void parseInvalidationCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        ConfigurationBuilder builder = holder.newConfigurationBuilder(name);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseClusteredCacheAttribute(reader, i, attribute, value, builder, CacheMode.INVALIDATION_ASYNC);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseCacheElement(reader, element, holder);
        }
    }

    protected void parseCacheElement(XMLExtendedStreamReader reader, Element element, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        switch (element) {
            case LOCKING: {
                this.parseLocking(reader, builder);
                break;
            }
            case TRANSACTION: {
                this.parseTransaction(reader, builder);
                break;
            }
            case EVICTION: {
                this.parseEviction(reader, builder);
                break;
            }
            case EXPIRATION: {
                this.parseExpiration(reader, builder);
                break;
            }
            case STORE: {
                this.parseCustomStore(reader, builder.loaders().addStore());
                break;
            }
            case FILE_STORE: {
                this.parseFileStore(reader, builder.loaders().addFileCacheStore());
                break;
            }
            default: {
                reader.handleAny((Object)holder);
            }
        }
    }

    private void parseStateTransfer(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    builder.clustering().stateTransfer().fetchInMemoryState(Boolean.parseBoolean(value));
                    continue block5;
                }
                case TIMEOUT: {
                    builder.clustering().stateTransfer().timeout(Long.parseLong(value));
                    continue block5;
                }
                case CHUNK_SIZE: {
                    builder.clustering().stateTransfer().chunkSize(Integer.parseInt(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    protected void parseLocking(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ISOLATION: {
                    builder.locking().isolationLevel(IsolationLevel.valueOf(value));
                    continue block6;
                }
                case STRIPING: {
                    builder.locking().useLockStriping(Boolean.parseBoolean(value));
                    continue block6;
                }
                case ACQUIRE_TIMEOUT: {
                    builder.locking().lockAcquisitionTimeout(Long.parseLong(value));
                    continue block6;
                }
                case CONCURRENCY_LEVEL: {
                    builder.locking().concurrencyLevel(Integer.parseInt(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    protected void parseTransaction(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STOP_TIMEOUT: {
                    builder.transaction().cacheStopTimeout(Long.parseLong(value));
                    continue block5;
                }
                case MODE: {
                    TransactionMode txMode = TransactionMode.valueOf(value);
                    builder.transaction().transactionMode(txMode.getMode());
                    builder.transaction().useSynchronization(!txMode.isXAEnabled());
                    builder.transaction().recovery().enabled(txMode.isRecoveryEnabled());
                    continue block5;
                }
                case LOCKING: {
                    builder.transaction().lockingMode(LockingMode.valueOf(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    protected void parseEviction(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STRATEGY: {
                    builder.eviction().strategy(EvictionStrategy.valueOf(value));
                    continue block4;
                }
                case MAX_ENTRIES: {
                    builder.eviction().maxEntries(Integer.parseInt(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseExpiration(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_IDLE: {
                    builder.expiration().maxIdle(Long.parseLong(value));
                    continue block5;
                }
                case LIFESPAN: {
                    builder.expiration().lifespan(Long.parseLong(value));
                    continue block5;
                }
                case INTERVAL: {
                    builder.expiration().wakeUpInterval(Long.parseLong(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    protected void parseCustomStore(XMLExtendedStreamReader reader, LegacyStoreConfigurationBuilder builder) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.CLASS);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CLASS: {
                    continue block3;
                }
                default: {
                    ParserAS7.parseStoreAttribute(reader, i, builder);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLStreamReader)reader, required);
        }
    }

    protected void parseFileStore(XMLExtendedStreamReader reader, FileCacheStoreConfigurationBuilder storeBuilder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    continue block4;
                }
                case PATH: {
                    storeBuilder.location(value);
                    continue block4;
                }
                default: {
                    ParserAS7.parseStoreAttribute(reader, i, storeBuilder);
                }
            }
        }
        this.parseStoreElements(reader, storeBuilder);
    }

    public static void parseStoreAttribute(XMLExtendedStreamReader reader, int index, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        String value = reader.getAttributeValue(index);
        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(index));
        storeBuilder.purgeSynchronously(true);
        switch (attribute) {
            case SHARED: {
                storeBuilder.loaders().shared(Boolean.parseBoolean(value));
                break;
            }
            case PRELOAD: {
                storeBuilder.loaders().preload(Boolean.parseBoolean(value));
                break;
            }
            case PASSIVATION: {
                storeBuilder.loaders().passivation(Boolean.parseBoolean(value));
                break;
            }
            case FETCH_STATE: {
                storeBuilder.fetchPersistentState(Boolean.parseBoolean(value));
                break;
            }
            case PURGE: {
                storeBuilder.purgeOnStartup(Boolean.parseBoolean(value));
                break;
            }
            case SINGLETON: {
                storeBuilder.singletonStore().enabled(Boolean.parseBoolean(value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, index);
            }
        }
    }

    private void parseStoreElements(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            ParserAS7.parseStoreElement(reader, storeBuilder);
        }
    }

    public static void parseStoreElement(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case WRITE_BEHIND: {
                ParserAS7.parseStoreWriteBehind(reader, storeBuilder.async().enable());
                break;
            }
            case PROPERTY: {
                ParserAS7.parseStoreProperty(reader, storeBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    public static void parseStoreWriteBehind(XMLExtendedStreamReader reader, AsyncStoreConfigurationBuilder storeBuilder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FLUSH_LOCK_TIMEOUT: {
                    storeBuilder.flushLockTimeout(Long.parseLong(value));
                    continue block6;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    storeBuilder.modificationQueueSize(Integer.parseInt(value));
                    continue block6;
                }
                case SHUTDOWN_TIMEOUT: {
                    storeBuilder.shutdownTimeout(Long.parseLong(value));
                    continue block6;
                }
                case THREAD_POOL_SIZE: {
                    storeBuilder.threadPoolSize(Integer.parseInt(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    public static void parseStoreProperty(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        String property = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.NAME.getLocalName());
        String value = reader.getElementText();
        storeBuilder.addProperty(property, value);
    }

    private void parseInterfaces(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERFACE: {
                    this.parseInterface(reader, holder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseInterface(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String name = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.NAME.getLocalName());
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INET_ADDRESS: {
                    String value = StringPropertyReplacer.replaceProperties(ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.VALUE.getLocalName()));
                    ParserContextAS7 parserContext = (ParserContextAS7)holder.getParserContext(ParserAS7.class);
                    try {
                        parserContext.addInterface(new NetworkInterface(name, InetAddress.getByName(value)));
                        continue block5;
                    }
                    catch (UnknownHostException e) {
                        throw ParseUtils.invalidAttributeValue((XMLStreamReader)reader, 0);
                    }
                }
            }
            reader.discardRemainder();
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseSocketBindingGroup(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParserContextAS7 parserContext = (ParserContextAS7)holder.getParserContext(ParserAS7.class);
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME.getLocalName(), Attribute.DEFAULT_INTERFACE.getLocalName());
        String portOffset = reader.getAttributeValue(null, Attribute.PORT_OFFSET.getLocalName());
        SocketBindingGroup socketBindingGroup = new SocketBindingGroup(attributes[0], attributes[1], portOffset == null ? 0 : Integer.parseInt(StringPropertyReplacer.replaceProperties(portOffset)));
        parserContext.addSocketBindingGroup(socketBindingGroup);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING: {
                    this.parseSocketBinding(reader, holder);
                    continue block4;
                }
                case OUTBOUND_SOCKET_BINDING: {
                    this.parseOutboundSocketBinding(reader, holder);
                    continue block4;
                }
            }
            reader.discardRemainder();
        }
    }

    private void parseSocketBinding(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME.getLocalName(), Attribute.PORT.getLocalName());
        ParserContextAS7 parserContext = (ParserContextAS7)holder.getParserContext(ParserAS7.class);
        SocketBindingGroup socketBindingGroup = parserContext.getCurrentSocketBindingGroup();
        String interfaceName = reader.getAttributeValue(null, Attribute.INTERFACE.getLocalName());
        if (interfaceName == null) {
            interfaceName = socketBindingGroup.defaultInterface();
        }
        InetAddress address = parserContext.getInterface(interfaceName).address();
        socketBindingGroup.addSocketBinding(new SocketBinding(attributes[0], address, Integer.parseInt(StringPropertyReplacer.replaceProperties(attributes[1]))));
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseOutboundSocketBinding(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String name = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME.getLocalName())[0];
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_DESTINATION: {
                    String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.HOST.getLocalName(), Attribute.PORT.getLocalName());
                    ParserContextAS7 parserContext = (ParserContextAS7)holder.getParserContext(ParserAS7.class);
                    SocketBindingGroup socketBindingGroup = parserContext.getCurrentSocketBindingGroup();
                    socketBindingGroup.addOutboundSocketBinding(new OutboundSocketBinding(name, attributes[0], Integer.parseInt(attributes[1])));
                    ParseUtils.requireNoContent((XMLStreamReader)reader);
                    return;
                }
            }
            reader.discardRemainder();
        }
        throw ParseUtils.missingRequiredElement((XMLStreamReader)reader, EnumSet.of(Element.REMOTE_DESTINATION));
    }
}

