/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.List;
import org.infinispan.configuration.cache.LoaderConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;

public class LoadersConfiguration {
    private final boolean passivation;
    private final boolean preload;
    private final boolean shared;
    private final List<LoaderConfiguration> cacheLoaders;

    LoadersConfiguration(boolean passivation, boolean preload, boolean shared, List<LoaderConfiguration> cacheLoaders) {
        this.passivation = passivation;
        this.preload = preload;
        this.shared = shared;
        this.cacheLoaders = cacheLoaders;
    }

    public boolean passivation() {
        return this.passivation;
    }

    public boolean preload() {
        return this.preload;
    }

    public boolean shared() {
        return this.shared;
    }

    public List<LoaderConfiguration> cacheLoaders() {
        return this.cacheLoaders;
    }

    public Boolean fetchPersistentState() {
        for (LoaderConfiguration c : this.cacheLoaders) {
            if (!(c instanceof StoreConfiguration) || !((StoreConfiguration)c).fetchPersistentState()) continue;
            return true;
        }
        return false;
    }

    public boolean usingCacheLoaders() {
        return !this.cacheLoaders.isEmpty();
    }

    public boolean usingAsyncStore() {
        for (LoaderConfiguration c : this.cacheLoaders) {
            if (!(c instanceof StoreConfiguration) || !((StoreConfiguration)c).async().enabled()) continue;
            return true;
        }
        return false;
    }

    public boolean usingChainingCacheLoader() {
        return !this.passivation() && this.cacheLoaders.size() > 1;
    }

    public String toString() {
        return "LoadersConfiguration{cacheLoaders=" + this.cacheLoaders + ", passivation=" + this.passivation + ", preload=" + this.preload + ", shared=" + this.shared + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadersConfiguration that = (LoadersConfiguration)o;
        if (this.passivation != that.passivation) {
            return false;
        }
        if (this.preload != that.preload) {
            return false;
        }
        if (this.shared != that.shared) {
            return false;
        }
        return !(this.cacheLoaders != null ? !((Object)this.cacheLoaders).equals(that.cacheLoaders) : that.cacheLoaders != null);
    }

    public int hashCode() {
        int result = this.passivation ? 1 : 0;
        result = 31 * result + (this.preload ? 1 : 0);
        result = 31 * result + (this.shared ? 1 : 0);
        result = 31 * result + (this.cacheLoaders != null ? ((Object)this.cacheLoaders).hashCode() : 0);
        return result;
    }
}

