/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DataLocality;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.L1Manager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.Immutables;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.concurrent.NotifyingFutureImpl;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistributionInterceptor
extends BaseRpcInterceptor {
    private DistributionManager dm;
    private CommandsFactory cf;
    private DataContainer dataContainer;
    private boolean isL1CacheEnabled;
    private boolean needReliableReturnValues;
    private EntryFactory entryFactory;
    private L1Manager l1Manager;
    private LockManager lockManager;
    static final RecipientGenerator CLEAR_COMMAND_GENERATOR = new RecipientGenerator(){

        @Override
        public List<Address> generateRecipients() {
            return null;
        }

        @Override
        public Collection<Object> getKeys() {
            return InfinispanCollections.emptySet();
        }
    };
    private boolean isPessimisticCache;
    private static final Log log = LogFactory.getLog(DistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void injectDependencies(DistributionManager distributionManager, CommandsFactory cf, DataContainer dataContainer, EntryFactory entryFactory, L1Manager l1Manager, LockManager lockManager) {
        this.dm = distributionManager;
        this.cf = cf;
        this.dataContainer = dataContainer;
        this.entryFactory = entryFactory;
        this.l1Manager = l1Manager;
        this.lockManager = lockManager;
    }

    @Start
    public void start() {
        this.isL1CacheEnabled = this.cacheConfiguration.clustering().l1().enabled();
        this.needReliableReturnValues = !this.cacheConfiguration.unsafe().unreliableReturnValues();
        this.isPessimisticCache = this.cacheConfiguration.transaction().lockingMode() == LockingMode.PESSIMISTIC;
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            Object returnValue = this.invokeNextInterceptor(ctx, command);
            if (returnValue != null && this.isL1CacheEnabled && !ctx.isOriginLocal()) {
                this.l1Manager.addRequestor(command.getKey(), ctx.getOrigin());
            }
            if (this.needsRemoteGet(ctx, command, returnValue == null)) {
                returnValue = this.remoteGetAndStoreInL1(ctx, command.getKey(), false, command);
            }
            return returnValue;
        }
        catch (SuspectException e) {
            return this.visitGetKeyValueCommand(ctx, command);
        }
    }

    private boolean needsRemoteGet(InvocationContext ctx, AbstractDataCommand command, boolean retvalCheck) {
        CacheEntry entry;
        return retvalCheck && !command.hasFlag(Flag.CACHE_MODE_LOCAL) && !command.hasFlag(Flag.SKIP_REMOTE_LOOKUP) && !command.hasFlag(Flag.IGNORE_RETURN_VALUES) && ((entry = ctx.lookupEntry(command.getKey())) == null || entry.isNull() || entry.isLockPlaceholder());
    }

    private Object remoteGetAndStoreInL1(InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command) throws Throwable {
        DataLocality locality;
        DataLocality dataLocality = locality = this.dm.getReadConsistentHash().isKeyLocalToNode(this.rpcManager.getAddress(), key) ? DataLocality.LOCAL : DataLocality.NOT_LOCAL;
        if (ctx.isOriginLocal() && !locality.isLocal() && this.isNotInL1(key)) {
            return this.realRemoteGet(ctx, key, true, isWrite, command);
        }
        if (locality.isUncertain()) {
            if (trace) {
                log.tracef("Key %s is mapped to local node %s, but a rehash is in progress so may need to look elsewhere", key, this.rpcManager.getAddress());
            }
            return this.realRemoteGet(ctx, key, false, isWrite, command);
        }
        if (trace) {
            log.tracef("Not doing a remote get for key %s since entry is mapped to current node (%s), or is in L1.  Owners are %s", key, this.rpcManager.getAddress(), this.dm.locate(key));
        }
        return null;
    }

    private Object realRemoteGet(InvocationContext ctx, Object key, boolean storeInL1, boolean isWrite, FlagAffectedCommand command) throws Throwable {
        if (trace) {
            log.tracef("Doing a remote get for key %s", key);
        }
        boolean acquireRemoteLock = false;
        if (ctx.isInTxScope()) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            acquireRemoteLock = isWrite && this.isPessimisticCache && !txContext.getAffectedKeys().contains(key);
        }
        InternalCacheEntry ice = this.dm.retrieveFromRemoteSource(key, ctx, acquireRemoteLock, command);
        if (acquireRemoteLock) {
            ((TxInvocationContext)ctx).addAffectedKey(key);
        }
        if (ice != null) {
            if (storeInL1) {
                if (this.isL1CacheEnabled) {
                    if (trace) {
                        log.tracef("Caching remotely retrieved entry for key %s in L1", key);
                    }
                    try {
                        long l1Lifespan = this.cacheConfiguration.clustering().l1().lifespan();
                        long lifespan = ice.getLifespan() < 0L ? l1Lifespan : Math.min(ice.getLifespan(), l1Lifespan);
                        PutKeyValueCommand put = this.cf.buildPutKeyValueCommand(ice.getKey(), ice.getValue(), lifespan, -1L, command.getFlags());
                        this.lockAndWrap(ctx, key, ice, command);
                        this.invokeNextInterceptor(ctx, put);
                    }
                    catch (Exception e) {
                        log.infof("Unable to store entry %s in L1 cache", key);
                        log.debug("Inability to store in L1 caused by", e);
                    }
                } else {
                    CacheEntry ce = ctx.lookupEntry(key);
                    if (ce == null || ce.isNull() || ce.isLockPlaceholder() || ce.getValue() == null) {
                        if (ce != null && ce.isChanged()) {
                            ce.setValue(ice.getValue());
                        } else if (isWrite) {
                            this.lockAndWrap(ctx, key, ice, command);
                        } else {
                            ctx.putLookedUpEntry(key, ice);
                        }
                    }
                }
            } else if (trace) {
                log.tracef("Not caching remotely retrieved entry for key %s in L1", key);
            }
            return ice.getValue();
        }
        return null;
    }

    private void lockAndWrap(InvocationContext ctx, Object key, InternalCacheEntry ice, FlagAffectedCommand command) throws InterruptedException {
        boolean skipLocking = this.hasSkipLocking(command);
        long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
        this.lockManager.acquireLock(ctx, key, lockTimeout, skipLocking);
        this.entryFactory.wrapEntryForPut(ctx, key, ice, false, command);
    }

    private boolean isNotInL1(Object key) {
        return !this.isL1CacheEnabled || !this.dataContainer.containsKey(key);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        SingleKeyRecipientGenerator skrg = new SingleKeyRecipientGenerator(command.getKey());
        Object returnValue = this.handleWriteCommand(ctx, command, skrg, false, false);
        if (this.isL1CacheEnabled && !ctx.isOriginLocal() && !skrg.generateRecipients().contains(ctx.getOrigin())) {
            this.l1Manager.addRequestor(command.getKey(), ctx.getOrigin());
        }
        return returnValue;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new MultipleKeysRecipientGenerator(command.getMap().keySet()), true, false);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()), false, false);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, CLEAR_COMMAND_GENERATOR, false, true);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()), false, false);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            Collection<Address> affectedNodes = this.dm.getAffectedNodes(command.getKeys());
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(affectedNodes);
            this.rpcManager.invokeRemotely(affectedNodes, (ReplicableCommand)command, true, true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            Future<?> f = this.flushL1Caches(ctx);
            this.sendCommitCommand(ctx, command);
            this.blockOnL1FutureIfNeeded(f);
        } else if (this.isL1CacheEnabled && !ctx.isOriginLocal() && !ctx.getLockedKeys().isEmpty()) {
            this.blockOnL1FutureIfNeeded(this.flushL1Caches(ctx));
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Future<?> flushL1Caches(InvocationContext ctx) {
        return this.isL1CacheEnabled ? this.l1Manager.flushCacheWithSimpleFuture(ctx.getLockedKeys(), null, ctx.getOrigin(), true) : null;
    }

    private void blockOnL1FutureIfNeeded(Future<?> f) {
        block3: {
            if (f != null && this.cacheConfiguration.transaction().syncCommitPhase()) {
                try {
                    f.get();
                }
                catch (Exception e) {
                    if (e.getCause() instanceof SuspectException) break block3;
                    log.failedInvalidatingRemoteCache(e);
                }
            }
        }
    }

    private void sendCommitCommand(TxInvocationContext ctx, CommitCommand command) throws TimeoutException, InterruptedException {
        Collection<Address> recipients = this.getCommitNodes(ctx);
        boolean syncCommitPhase = this.cacheConfiguration.transaction().syncCommitPhase();
        this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)command, syncCommitPhase, true);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            if (command.isOnePhaseCommit()) {
                this.flushL1Caches(ctx);
            }
            Collection<Address> recipients = this.dm.getAffectedNodes(ctx.getAffectedKeys());
            this.prepareOnAffectedNodes(ctx, command, recipients, this.defaultSynchronous);
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(recipients);
        } else if (this.isL1CacheEnabled && command.isOnePhaseCommit() && !ctx.isOriginLocal() && !ctx.getLockedKeys().isEmpty()) {
            this.flushL1Caches(ctx);
        }
        return retVal;
    }

    protected void prepareOnAffectedNodes(TxInvocationContext ctx, PrepareCommand command, Collection<Address> recipients, boolean sync) {
        this.rpcManager.invokeRemotely(recipients, command, sync);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            this.rpcManager.invokeRemotely(this.getCommitNodes(ctx), (ReplicableCommand)command, this.cacheConfiguration.transaction().syncRollbackPhase(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private void remoteGetBeforeWrite(InvocationContext ctx, WriteCommand command, KeyGenerator keygen) throws Throwable {
        if (this.isNeedReliableReturnValues(command) || command.isConditional() && ctx.isInTxScope()) {
            for (Object k : keygen.getKeys()) {
                this.remoteGetAndStoreInL1(ctx, k, true, command);
            }
        }
    }

    private boolean isNeedReliableReturnValues(FlagAffectedCommand command) {
        return !command.hasFlag(Flag.SKIP_REMOTE_LOOKUP) && !command.hasFlag(Flag.IGNORE_RETURN_VALUES) && this.needReliableReturnValues;
    }

    private Object handleWriteCommand(InvocationContext ctx, WriteCommand command, RecipientGenerator recipientGenerator, boolean skipRemoteGet, boolean skipL1Invalidation) throws Throwable {
        if (ctx.isOriginLocal() && !skipRemoteGet) {
            this.remoteGetBeforeWrite(ctx, command, recipientGenerator);
        }
        boolean sync = this.isSynchronous(command);
        if (this.isLocalModeForced(command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (command.isSuccessful() && !ctx.isInTxScope()) {
            NotifyingNotifiableFuture<Object> futureToReturn = null;
            Future<Object> invalidationFuture = null;
            if (ctx.isOriginLocal()) {
                int numCallRecipients;
                List<Address> rec = recipientGenerator.generateRecipients();
                int n = numCallRecipients = rec == null ? 0 : rec.size();
                if (trace) {
                    log.tracef("Invoking command %s on hosts %s", command, rec);
                }
                boolean useFuture = ctx.isUseFutureReturnType();
                if (this.isL1CacheEnabled && !skipL1Invalidation) {
                    if (this.rpcManager.getTransport().getMembers().size() > numCallRecipients) {
                        if (trace) {
                            log.tracef("Put occurring on node, requesting L1 cache invalidation for keys %s. Other data owners are %s", command.getAffectedKeys(), this.dm.getAffectedNodes(command.getAffectedKeys()));
                        }
                        if (useFuture) {
                            futureToReturn = this.l1Manager.flushCache(recipientGenerator.getKeys(), returnValue, ctx.getOrigin(), !(command instanceof RemoveCommand));
                        } else {
                            invalidationFuture = this.l1Manager.flushCacheWithSimpleFuture(recipientGenerator.getKeys(), returnValue, ctx.getOrigin(), !(command instanceof RemoveCommand));
                        }
                    } else if (trace) {
                        log.tracef("Not performing invalidation! numCallRecipients=%s", numCallRecipients);
                    }
                }
                if (!this.isSingleOwnerAndLocal(recipientGenerator)) {
                    if (useFuture) {
                        if (futureToReturn == null) {
                            futureToReturn = new NotifyingFutureImpl(returnValue);
                        }
                        this.rpcManager.invokeRemotelyInFuture(rec, command, futureToReturn);
                        return futureToReturn;
                    }
                    this.rpcManager.invokeRemotely(rec, command, sync);
                } else if (useFuture && futureToReturn != null) {
                    return futureToReturn;
                }
                if (invalidationFuture != null && sync) {
                    invalidationFuture.get();
                    if (trace) {
                        log.tracef("Finished invalidating keys %s ", recipientGenerator.getKeys());
                    }
                }
            } else if (this.isL1CacheEnabled && !skipL1Invalidation) {
                if (trace) {
                    log.tracef("Put occurring on node, requesting cache invalidation for keys %s. Origin of command is remote", command.getAffectedKeys());
                }
                invalidationFuture = this.l1Manager.flushCacheWithSimpleFuture(recipientGenerator.getKeys(), returnValue, ctx.getOrigin(), !(command instanceof RemoveCommand));
                if (sync) {
                    block26: {
                        try {
                            invalidationFuture.get();
                        }
                        catch (ExecutionException ee) {
                            if (ee.getCause() instanceof SuspectException) break block26;
                            throw ee.getCause();
                        }
                    }
                    if (trace) {
                        log.tracef("Finished invalidating keys %s ", recipientGenerator.getKeys());
                    }
                }
            }
        }
        return returnValue;
    }

    private boolean isSingleOwnerAndLocal(RecipientGenerator recipientGenerator) {
        List<Address> recipients;
        return this.cacheConfiguration.clustering().hash().numOwners() == 1 && (recipients = recipientGenerator.generateRecipients()) != null && recipients.size() == 1 && recipients.get(0).equals(this.rpcManager.getTransport().getAddress());
    }

    private Collection<Address> getCommitNodes(TxInvocationContext ctx) {
        LocalTransaction localTx = (LocalTransaction)ctx.getCacheTransaction();
        Collection<Address> affectedNodes = this.dm.getAffectedNodes(ctx.getAffectedKeys());
        List<Address> members = this.dm.getConsistentHash().getMembers();
        return localTx.getCommitNodes(affectedNodes, this.rpcManager.getTopologyId(), members);
    }

    class MultipleKeysRecipientGenerator
    implements RecipientGenerator {
        final Collection<Object> keys;
        List<Address> recipients = null;

        MultipleKeysRecipientGenerator(Collection<Object> keys) {
            this.keys = keys;
        }

        @Override
        public List<Address> generateRecipients() {
            if (this.recipients == null) {
                Set<Address> addresses = DistributionInterceptor.this.dm.locateAll(this.keys);
                this.recipients = Immutables.immutableListConvert(addresses);
            }
            return this.recipients;
        }

        @Override
        public Collection<Object> getKeys() {
            return this.keys;
        }
    }

    class SingleKeyRecipientGenerator
    implements RecipientGenerator {
        final Object key;
        final Set<Object> keys;
        List<Address> recipients = null;

        SingleKeyRecipientGenerator(Object key) {
            this.key = key;
            this.keys = Collections.singleton(key);
        }

        @Override
        public List<Address> generateRecipients() {
            if (this.recipients == null) {
                this.recipients = DistributionInterceptor.this.dm.locate(this.key);
            }
            return this.recipients;
        }

        @Override
        public Collection<Object> getKeys() {
            return this.keys;
        }
    }

    static interface RecipientGenerator
    extends KeyGenerator {
        public List<Address> generateRecipients();
    }

    static interface KeyGenerator {
        public Collection<Object> getKeys();
    }
}

