/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.xsite.BackupSender;

public class BaseBackupInterceptor
extends CommandInterceptor {
    protected BackupSender backupSender;
    protected TransactionTable txTable;

    @Inject
    void init(BackupSender sender, TransactionTable txTable) {
        this.backupSender = sender;
        this.txTable = txTable;
    }

    protected boolean isTxFromRemoteSite(GlobalTransaction gtx) {
        LocalTransaction remoteTx = this.txTable.getLocalTransaction(gtx);
        return remoteTx != null && remoteTx.isFromRemoteSite();
    }

    protected boolean shouldInvokeRemoteTxCommand(TxInvocationContext ctx) {
        return ctx.isOriginLocal() && ctx.hasModifications();
    }
}

