/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.InfinispanCollections;

public class CacheTopology {
    private final int topologyId;
    private final ConsistentHash currentCH;
    private final ConsistentHash pendingCH;

    public CacheTopology(int topologyId, ConsistentHash currentCH, ConsistentHash pendingCH) {
        this.topologyId = topologyId;
        this.currentCH = currentCH;
        this.pendingCH = pendingCH;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    public ConsistentHash getCurrentCH() {
        return this.currentCH;
    }

    public ConsistentHash getPendingCH() {
        return this.pendingCH;
    }

    public List<Address> getMembers() {
        if (this.pendingCH != null) {
            return this.pendingCH.getMembers();
        }
        if (this.currentCH != null) {
            return this.currentCH.getMembers();
        }
        return InfinispanCollections.emptyList();
    }

    public ConsistentHash getReadConsistentHash() {
        return this.currentCH;
    }

    public ConsistentHash getWriteConsistentHash() {
        if (this.pendingCH != null) {
            return this.pendingCH;
        }
        return this.currentCH;
    }

    public String toString() {
        return "CacheTopology{id=" + this.topologyId + ", currentCH=" + this.currentCH + ", pendingCH=" + this.pendingCH + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<CacheTopology> {
        @Override
        public void writeObject(ObjectOutput output, CacheTopology cacheTopology) throws IOException {
            output.writeInt(cacheTopology.topologyId);
            output.writeObject(cacheTopology.currentCH);
            output.writeObject(cacheTopology.pendingCH);
        }

        @Override
        public CacheTopology readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            int topologyId = unmarshaller.readInt();
            ConsistentHash currentCH = (ConsistentHash)unmarshaller.readObject();
            ConsistentHash pendingCH = (ConsistentHash)unmarshaller.readObject();
            return new CacheTopology(topologyId, currentCH, pendingCH);
        }

        @Override
        public Integer getId() {
            return 75;
        }

        @Override
        public Set<Class<? extends CacheTopology>> getTypeClasses() {
            return Collections.singleton(CacheTopology.class);
        }
    }
}

