/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.upgrade;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.upgrade.Migrator;
import org.rhq.helpers.pluginAnnotations.agent.Operation;

@MBean(objectName="RollingUpgradeManager", description="This component handles the control hooks to handle migrating data from one version of Infinispan to another")
@Scope(value=Scopes.NAMED_CACHE)
@SurvivesRestarts
public class RollingUpgradeManager {
    private final ConcurrentMap<String, Migrator> migrators = new ConcurrentHashMap<String, Migrator>(2);

    @ManagedOperation(description="Dumps the global known keyset to a well-known key for retrieval by the upgrade process")
    @Operation(displayName="Dumps the global known keyset to a well-known key for retrieval by the upgrade process")
    public void recordKnownGlobalKeyset() {
        for (Migrator m : this.migrators.values()) {
            m.recordKnownGlobalKeyset();
        }
    }

    public void addMigrator(Migrator migrator) {
        this.migrators.putIfAbsent(migrator.getCacheName(), migrator);
    }
}

