/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.Version;
import org.infinispan.configuration.global.ExecutorFactoryConfiguration;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.configuration.global.ScheduledExecutorFactoryConfiguration;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.infinispan.configuration.global.ShutdownConfiguration;
import org.infinispan.configuration.global.SitesConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public class GlobalConfiguration {
    public static final short DEFAULT_MARSHALL_VERSION = Version.getVersionShort();
    private final ExecutorFactoryConfiguration asyncListenerExecutor;
    private final ExecutorFactoryConfiguration asyncTransportExecutor;
    private final ScheduledExecutorFactoryConfiguration evictionScheduledExecutor;
    private final ScheduledExecutorFactoryConfiguration replicationQueueScheduledExecutor;
    private final GlobalJmxStatisticsConfiguration globalJmxStatistics;
    private final TransportConfiguration transport;
    private final SerializationConfiguration serialization;
    private final ShutdownConfiguration shutdown;
    private final Map<Class<?>, ?> modules;
    private final SitesConfiguration sites;
    private final ClassLoader cl;

    GlobalConfiguration(ExecutorFactoryConfiguration asyncListenerExecutor, ExecutorFactoryConfiguration asyncTransportExecutor, ScheduledExecutorFactoryConfiguration evictionScheduledExecutor, ScheduledExecutorFactoryConfiguration replicationQueueScheduledExecutor, GlobalJmxStatisticsConfiguration globalJmxStatistics, TransportConfiguration transport, SerializationConfiguration serialization, ShutdownConfiguration shutdown, List<?> modules, SitesConfiguration sites, ClassLoader cl) {
        this.asyncListenerExecutor = asyncListenerExecutor;
        this.asyncTransportExecutor = asyncTransportExecutor;
        this.evictionScheduledExecutor = evictionScheduledExecutor;
        this.replicationQueueScheduledExecutor = replicationQueueScheduledExecutor;
        this.globalJmxStatistics = globalJmxStatistics;
        this.transport = transport;
        this.serialization = serialization;
        this.shutdown = shutdown;
        HashMap moduleMap = new HashMap();
        for (Object module : modules) {
            moduleMap.put(module.getClass(), module);
        }
        this.modules = Collections.unmodifiableMap(moduleMap);
        this.sites = sites;
        this.cl = cl;
    }

    public ExecutorFactoryConfiguration asyncListenerExecutor() {
        return this.asyncListenerExecutor;
    }

    public ExecutorFactoryConfiguration asyncTransportExecutor() {
        return this.asyncTransportExecutor;
    }

    public ScheduledExecutorFactoryConfiguration evictionScheduledExecutor() {
        return this.evictionScheduledExecutor;
    }

    public ScheduledExecutorFactoryConfiguration replicationQueueScheduledExecutor() {
        return this.replicationQueueScheduledExecutor;
    }

    public GlobalJmxStatisticsConfiguration globalJmxStatistics() {
        return this.globalJmxStatistics;
    }

    public TransportConfiguration transport() {
        return this.transport;
    }

    public SerializationConfiguration serialization() {
        return this.serialization;
    }

    public ShutdownConfiguration shutdown() {
        return this.shutdown;
    }

    public <T> T module(Class<T> moduleClass) {
        return (T)this.modules.get(moduleClass);
    }

    public Map<Class<?>, ?> modules() {
        return this.modules;
    }

    public ClassLoader classLoader() {
        return this.cl;
    }

    public SitesConfiguration sites() {
        return this.sites;
    }

    public String toString() {
        return "GlobalConfiguration{asyncListenerExecutor=" + this.asyncListenerExecutor + ", asyncTransportExecutor=" + this.asyncTransportExecutor + ", evictionScheduledExecutor=" + this.evictionScheduledExecutor + ", replicationQueueScheduledExecutor=" + this.replicationQueueScheduledExecutor + ", globalJmxStatistics=" + this.globalJmxStatistics + ", transport=" + this.transport + ", serialization=" + this.serialization + ", shutdown=" + this.shutdown + ", modules=" + this.modules + ", sites=" + this.sites + ", cl=" + this.cl + '}';
    }
}

