/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheImpl;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.transaction.xa.recovery.RecoveryAdminOperations;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.xsite.XSiteAdminOperations;

public class InternalCacheFactory<K, V>
extends AbstractNamedCacheComponentFactory {
    private ClassLoader defaultClassLoader;

    public Cache<K, V> createCache(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) throws ConfigurationException {
        try {
            return this.createAndWire(configuration, globalComponentRegistry, cacheName);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected AdvancedCache<K, V> createAndWire(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) throws Exception {
        CacheImpl cache = new CacheImpl(cacheName);
        this.bootstrap(cacheName, cache, configuration, globalComponentRegistry);
        return cache;
    }

    private void bootstrap(String cacheName, AdvancedCache<?, ?> cache, Configuration configuration, GlobalComponentRegistry globalComponentRegistry) {
        this.configuration = configuration;
        this.componentRegistry = new ComponentRegistry(cacheName, configuration, cache, globalComponentRegistry, this.defaultClassLoader);
        this.componentRegistry.registerComponent(cache, Cache.class.getName(), true);
        this.componentRegistry.registerComponent(new CacheJmxRegistration(), CacheJmxRegistration.class.getName(), true);
        if (configuration.transaction().transactionMode().isTransactional() && configuration.transaction().recovery().enabled()) {
            this.componentRegistry.registerComponent(new RecoveryAdminOperations(), RecoveryAdminOperations.class.getName(), true);
        }
        if (!configuration.sites().inUseBackups().isEmpty()) {
            this.componentRegistry.registerComponent(new XSiteAdminOperations(), XSiteAdminOperations.class.getName(), true);
        }
        this.componentRegistry.registerComponent(new RollingUpgradeManager(), RollingUpgradeManager.class.getName(), true);
    }

    public void setDefaultClassLoader(ClassLoader loader) {
        this.defaultClassLoader = loader;
    }

    @Override
    public <T> T construct(Class<T> componentType) {
        throw new UnsupportedOperationException("Should never be invoked - this is a bootstrap factory.");
    }
}

