/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.transaction.WriteSkewHelper;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public interface ClusteringDependentLogic {
    public static final Log log = LogFactory.getLog(ClusteringDependentLogic.class);

    public boolean localNodeIsOwner(Object var1);

    public boolean localNodeIsPrimaryOwner(Object var1);

    public Address getPrimaryOwner(Object var1);

    public void commitEntry(CacheEntry var1, EntryVersion var2, boolean var3);

    public Collection<Address> getOwners(Collection<Object> var1);

    public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator var1, TxInvocationContext var2, VersionedPrepareCommand var3);

    public Address getAddress();

    public static final class DistributionLogic
    implements ClusteringDependentLogic {
        private DistributionManager dm;
        private DataContainer dataContainer;
        private Configuration configuration;
        private RpcManager rpcManager;
        private StateTransferLock stateTransferLock;
        private final WriteSkewHelper.KeySpecificLogic keySpecificLogic = new WriteSkewHelper.KeySpecificLogic(){

            @Override
            public boolean performCheckOnKey(Object key) {
                return DistributionLogic.this.localNodeIsOwner(key);
            }
        };

        @Inject
        public void init(DistributionManager dm, DataContainer dataContainer, Configuration configuration, RpcManager rpcManager, StateTransferLock stateTransferLock) {
            this.dm = dm;
            this.dataContainer = dataContainer;
            this.configuration = configuration;
            this.rpcManager = rpcManager;
            this.stateTransferLock = stateTransferLock;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return this.dm.getLocality(key).isLocal();
        }

        @Override
        public Address getAddress() {
            return this.rpcManager.getAddress();
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            Address address = this.rpcManager.getAddress();
            boolean result = this.dm.getPrimaryLocation(key).equals(address);
            return result;
        }

        @Override
        public Address getPrimaryOwner(Object key) {
            return this.dm.getPrimaryLocation(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commitEntry(CacheEntry entry, EntryVersion newVersion, boolean skipOwnershipCheck) {
            this.stateTransferLock.acquireSharedTopologyLock();
            try {
                boolean doCommit = true;
                if (!(skipOwnershipCheck || entry.isRemoved() || this.localNodeIsOwner(entry.getKey()))) {
                    if (this.configuration.clustering().l1().enabled()) {
                        this.dm.transformForL1(entry);
                    } else {
                        doCommit = false;
                    }
                }
                if (doCommit) {
                    entry.commit(this.dataContainer, newVersion);
                } else {
                    entry.rollback();
                }
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
        }

        @Override
        public Collection<Address> getOwners(Collection<Object> keys) {
            return this.dm.getAffectedNodes(keys);
        }

        @Override
        public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            EntryVersionsMap uv = WriteSkewHelper.performWriteSkewCheckAndReturnNewVersions(prepareCommand, this.dataContainer, versionGenerator, context, this.keySpecificLogic);
            CacheTransaction cacheTransaction = context.getCacheTransaction();
            EntryVersionsMap uvOld = cacheTransaction.getUpdatedEntryVersions();
            if (uvOld != null && !uvOld.isEmpty()) {
                uvOld.putAll(uv);
                uv = uvOld;
            }
            cacheTransaction.setUpdatedEntryVersions(uv);
            return uv.isEmpty() ? null : uv;
        }
    }

    public static final class AllNodesLogic
    implements ClusteringDependentLogic {
        private DataContainer dataContainer;
        private RpcManager rpcManager;
        private static final WriteSkewHelper.KeySpecificLogic keySpecificLogic = new WriteSkewHelper.KeySpecificLogic(){

            @Override
            public boolean performCheckOnKey(Object key) {
                return true;
            }
        };

        @Inject
        public void init(DataContainer dc, RpcManager rpcManager) {
            this.dataContainer = dc;
            this.rpcManager = rpcManager;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return true;
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            return this.rpcManager == null || this.rpcManager.getTransport().isCoordinator();
        }

        @Override
        public Address getPrimaryOwner(Object key) {
            if (this.rpcManager == null) {
                throw new IllegalStateException("Cannot invoke this method for local caches");
            }
            return this.rpcManager.getTransport().getCoordinator();
        }

        @Override
        public void commitEntry(CacheEntry entry, EntryVersion newVersion, boolean skipOwnershipCheck) {
            entry.commit(this.dataContainer, newVersion);
        }

        @Override
        public Collection<Address> getOwners(Collection<Object> keys) {
            return null;
        }

        @Override
        public Address getAddress() {
            return this.rpcManager.getAddress();
        }

        @Override
        public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            if (this.rpcManager.getTransport().isCoordinator()) {
                EntryVersionsMap uv = WriteSkewHelper.performWriteSkewCheckAndReturnNewVersions(prepareCommand, this.dataContainer, versionGenerator, context, keySpecificLogic);
                context.getCacheTransaction().setUpdatedEntryVersions(uv);
                return uv;
            }
            if (prepareCommand.getModifications().length == 0) {
                context.getCacheTransaction().setUpdatedEntryVersions(new EntryVersionsMap());
            }
            return null;
        }
    }
}

