/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.DisplayType;
import org.rhq.helpers.pluginAnnotations.agent.MeasurementType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;
import org.rhq.helpers.pluginAnnotations.agent.Parameter;
import org.rhq.helpers.pluginAnnotations.agent.Units;

@MBean(objectName="RpcManager", description="Manages all remote calls to remote cache instances in the cluster.")
public class RpcManagerImpl
implements RpcManager {
    private static final Log log = LogFactory.getLog(RpcManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private Transport t;
    private final AtomicLong replicationCount = new AtomicLong(0L);
    private final AtomicLong replicationFailures = new AtomicLong(0L);
    private final AtomicLong totalReplicationTime = new AtomicLong(0L);
    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", writable=true)
    boolean statisticsEnabled = false;
    private Configuration configuration;
    private GlobalConfiguration globalCfg;
    private ReplicationQueue replicationQueue;
    private ExecutorService asyncExecutor;
    private CommandsFactory cf;
    private LocalTopologyManager localTopologyManager;
    private StateTransferManager stateTransferManager;
    private String cacheName;

    @Inject
    public void injectDependencies(Transport t, Cache cache, Configuration cfg, ReplicationQueue replicationQueue, CommandsFactory cf, @ComponentName(value="org.infinispan.executors.transport") ExecutorService e, LocalTopologyManager localTopologyManager, StateTransferManager stateTransferManager, GlobalConfiguration globalCfg) {
        this.t = t;
        this.configuration = cfg;
        this.cacheName = cache.getName();
        this.globalCfg = globalCfg;
        this.replicationQueue = replicationQueue;
        this.asyncExecutor = e;
        this.cf = cf;
        this.localTopologyManager = localTopologyManager;
        this.stateTransferManager = stateTransferManager;
    }

    @Start(priority=9)
    private void start() {
        this.statisticsEnabled = this.configuration.jmxStatistics().enabled();
    }

    @ManagedAttribute(description="Retrieves the committed view.")
    @Metric(displayName="Committed view", dataType=DataType.TRAIT)
    public String getCommittedViewAsString() {
        return this.localTopologyManager == null ? "N/A" : String.valueOf(this.localTopologyManager.getCacheTopology(this.cacheName).getCurrentCH());
    }

    @ManagedAttribute(description="Retrieves the pending view.")
    @Metric(displayName="Pending view", dataType=DataType.TRAIT)
    public String getPendingViewAsString() {
        return this.localTopologyManager == null ? "N/A" : String.valueOf(this.localTopologyManager.getCacheTopology(this.cacheName).getPendingCH());
    }

    private boolean useReplicationQueue(boolean sync) {
        return !sync && this.replicationQueue != null && this.replicationQueue.isEnabled();
    }

    @Override
    public final Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter) {
        if (!this.configuration.clustering().cacheMode().isClustered()) {
            throw new IllegalStateException("Trying to invoke a remote command but the cache is not clustered");
        }
        List<Address> clusterMembers = this.t.getMembers();
        if (clusterMembers.size() < 2) {
            log.tracef("We're the only member in the cluster; Don't invoke remotely.", new Object[0]);
            return InfinispanCollections.emptyMap();
        }
        long startTimeNanos = 0L;
        if (this.statisticsEnabled) {
            startTimeNanos = System.nanoTime();
        }
        try {
            TopologyAffectedCommand topologyAffectedCommand;
            if (rpcCommand instanceof TopologyAffectedCommand && (topologyAffectedCommand = (TopologyAffectedCommand)rpcCommand).getTopologyId() == -1) {
                topologyAffectedCommand.setTopologyId(this.stateTransferManager.getCacheTopology().getTopologyId());
            }
            Map<Address, Response> result = this.t.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, responseFilter);
            if (this.statisticsEnabled) {
                this.replicationCount.incrementAndGet();
            }
            Map<Address, Response> map = result;
            return map;
        }
        catch (CacheException e) {
            log.trace("replication exception: ", e);
            if (this.statisticsEnabled) {
                this.replicationFailures.incrementAndGet();
            }
            throw e;
        }
        catch (Throwable th) {
            log.unexpectedErrorReplicating(th);
            if (this.statisticsEnabled) {
                this.replicationFailures.incrementAndGet();
            }
            throw new CacheException(th);
        }
        finally {
            if (this.statisticsEnabled) {
                long timeTaken = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimeNanos, TimeUnit.NANOSECONDS);
                this.totalReplicationTime.getAndAdd(timeTaken);
            }
        }
    }

    @Override
    public final Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue) {
        return this.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, null);
    }

    @Override
    public final Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout) {
        return this.invokeRemotely(recipients, rpcCommand, mode, timeout, false, null);
    }

    @Override
    public final void broadcastRpcCommand(ReplicableCommand rpc, boolean sync) throws RpcException {
        this.broadcastRpcCommand(rpc, sync, false);
    }

    @Override
    public final void broadcastRpcCommand(ReplicableCommand rpc, boolean sync, boolean usePriorityQueue) throws RpcException {
        if (this.useReplicationQueue(sync)) {
            this.replicationQueue.add(rpc);
        } else {
            this.invokeRemotely(null, rpc, sync, usePriorityQueue);
        }
    }

    @Override
    public final void broadcastRpcCommandInFuture(ReplicableCommand rpc, NotifyingNotifiableFuture<Object> l) {
        this.broadcastRpcCommandInFuture(rpc, false, l);
    }

    @Override
    public final void broadcastRpcCommandInFuture(ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> l) {
        this.invokeRemotelyInFuture(null, rpc, usePriorityQueue, l);
    }

    @Override
    public final Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, boolean sync) throws RpcException {
        return this.invokeRemotely(recipients, rpc, sync, false);
    }

    @Override
    public final Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, boolean sync, boolean usePriorityQueue) throws RpcException {
        return this.invokeRemotely(recipients, rpc, sync, usePriorityQueue, this.configuration.clustering().sync().replTimeout());
    }

    public final Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, boolean sync, boolean usePriorityQueue, long timeout) throws RpcException {
        ResponseMode responseMode = this.getResponseMode(sync);
        return this.invokeRemotely(recipients, rpc, sync, usePriorityQueue, timeout, responseMode);
    }

    private Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, boolean sync, boolean usePriorityQueue, long timeout, ResponseMode responseMode) {
        if (trace) {
            log.tracef("%s broadcasting call %s to recipient list %s", this.t.getAddress(), rpc, recipients);
        }
        if (this.useReplicationQueue(sync)) {
            this.replicationQueue.add(rpc);
            return null;
        }
        if (!(rpc instanceof CacheRpcCommand)) {
            rpc = this.cf.buildSingleRpcCommand(rpc);
        }
        Map<Address, Response> rsps = this.invokeRemotely(recipients, rpc, responseMode, timeout, usePriorityQueue);
        if (trace) {
            log.tracef("Response(s) to %s is %s", rpc, rsps);
        }
        if (sync) {
            this.checkResponses(rsps);
        }
        return rsps;
    }

    @Override
    public final void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, NotifyingNotifiableFuture<Object> l) {
        this.invokeRemotelyInFuture(recipients, rpc, false, l);
    }

    @Override
    public final void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> l) {
        this.invokeRemotelyInFuture(recipients, rpc, usePriorityQueue, l, this.configuration.clustering().sync().replTimeout());
    }

    @Override
    public final void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> l, long timeout) {
        this.invokeRemotelyInFuture(recipients, rpc, usePriorityQueue, l, timeout, false);
    }

    @Override
    public void invokeRemotelyInFuture(final Collection<Address> recipients, final ReplicableCommand rpc, final boolean usePriorityQueue, final NotifyingNotifiableFuture<Object> l, final long timeout, boolean ignoreLeavers) {
        if (trace) {
            log.tracef("%s invoking in future call %s to recipient list %s", this.t.getAddress(), rpc, recipients);
        }
        final ResponseMode responseMode = ignoreLeavers ? ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS : ResponseMode.SYNCHRONOUS;
        final CountDownLatch futureSet = new CountDownLatch(1);
        Callable<Object> c = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Map result = null;
                try {
                    result = RpcManagerImpl.this.invokeRemotely((Collection<Address>)recipients, rpc, true, usePriorityQueue, timeout, responseMode);
                }
                finally {
                    try {
                        futureSet.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        l.notifyDone();
                    }
                }
                return result;
            }
        };
        l.setNetworkFuture(this.asyncExecutor.submit(c));
        futureSet.countDown();
    }

    @Override
    public Transport getTransport() {
        return this.t;
    }

    private ResponseMode getResponseMode(boolean sync) {
        return sync ? ResponseMode.SYNCHRONOUS : ResponseMode.getAsyncResponseMode(this.configuration);
    }

    private void checkResponses(Map<Address, Response> rsps) {
        if (rsps != null) {
            for (Map.Entry<Address, Response> rsp : rsps.entrySet()) {
                if (rsp == null || !(rsp.getValue() instanceof Throwable)) continue;
                Throwable throwable = (Throwable)((Object)rsp.getValue());
                if (trace) {
                    log.tracef("Received Throwable from remote node %s", throwable, rsp.getKey());
                }
                throw new RpcException(throwable);
            }
        }
    }

    @ManagedOperation(description="Resets statistics gathered by this component")
    @Operation(displayName="Reset statistics")
    public void resetStatistics() {
        this.replicationCount.set(0L);
        this.replicationFailures.set(0L);
        this.totalReplicationTime.set(0L);
    }

    @ManagedAttribute(description="Number of successful replications")
    @Metric(displayName="Number of successful replications", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getReplicationCount() {
        if (!this.isStatisticsEnabled()) {
            return -1L;
        }
        return this.replicationCount.get();
    }

    @ManagedAttribute(description="Number of failed replications")
    @Metric(displayName="Number of failed replications", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getReplicationFailures() {
        if (!this.isStatisticsEnabled()) {
            return -1L;
        }
        return this.replicationFailures.get();
    }

    @Metric(displayName="Statistics enabled", dataType=DataType.TRAIT)
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Operation(displayName="Enable/disable statistics")
    public void setStatisticsEnabled(@Parameter(name="enabled", description="Whether statistics should be enabled or disabled (true/false)") boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @ManagedAttribute(description="Successful replications as a ratio of total replications")
    public String getSuccessRatio() {
        if (this.replicationCount.get() == 0L || !this.statisticsEnabled) {
            return "N/A";
        }
        double ration = this.calculateSuccessRatio() * 100.0;
        return NumberFormat.getInstance().format(ration) + "%";
    }

    @ManagedAttribute(description="Successful replications as a ratio of total replications in numeric double format")
    @Metric(displayName="Successful replication ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getSuccessRatioFloatingPoint() {
        if (this.replicationCount.get() == 0L || !this.statisticsEnabled) {
            return 0.0;
        }
        return this.calculateSuccessRatio();
    }

    private double calculateSuccessRatio() {
        double totalCount = this.replicationCount.get() + this.replicationFailures.get();
        return (double)this.replicationCount.get() / totalCount;
    }

    @ManagedAttribute(description="The average time spent in the transport layer, in milliseconds")
    @Metric(displayName="Average time spent in the transport layer", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageReplicationTime() {
        if (this.replicationCount.get() == 0L) {
            return 0L;
        }
        return this.totalReplicationTime.get() / this.replicationCount.get();
    }

    public void setTransport(Transport t) {
        this.t = t;
    }

    @Override
    public Address getAddress() {
        return this.t != null ? this.t.getAddress() : null;
    }

    @Override
    public int getTopologyId() {
        return this.stateTransferManager.getCacheTopology().getTopologyId();
    }

    @Override
    public List<Address> getMembers() {
        return this.stateTransferManager.getCacheTopology().getMembers();
    }
}

