/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateConsumerImpl;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InboundTransferTask {
    private static final Log log = LogFactory.getLog(InboundTransferTask.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Set<Integer> segments = new CopyOnWriteArraySet<Integer>();
    private final Set<Integer> finishedSegments = new CopyOnWriteArraySet<Integer>();
    private final Address source;
    private volatile boolean isCancelled = false;
    private final StateConsumerImpl stateConsumer;
    private final int topologyId;
    private final RpcManager rpcManager;
    private final CommandsFactory commandsFactory;
    private final long timeout;
    private final String cacheName;

    public InboundTransferTask(Set<Integer> segments, Address source, int topologyId, StateConsumerImpl stateConsumer, RpcManager rpcManager, CommandsFactory commandsFactory, long timeout, String cacheName) {
        if (segments == null || segments.isEmpty()) {
            throw new IllegalArgumentException("segments must not be null or empty");
        }
        if (source == null) {
            throw new IllegalArgumentException("Source address cannot be null");
        }
        this.segments.addAll(segments);
        this.source = source;
        this.topologyId = topologyId;
        this.stateConsumer = stateConsumer;
        this.rpcManager = rpcManager;
        this.commandsFactory = commandsFactory;
        this.timeout = timeout;
        this.cacheName = cacheName;
    }

    public Set<Integer> getSegments() {
        return this.segments;
    }

    public Set<Integer> getUnfinishedSegments() {
        HashSet<Integer> unfinishedSegments = new HashSet<Integer>(this.segments);
        unfinishedSegments.removeAll(this.finishedSegments);
        return unfinishedSegments;
    }

    public Address getSource() {
        return this.source;
    }

    public boolean requestTransactions() {
        if (trace) {
            log.tracef("Requesting transactions for segments %s of cache %s from node %s", this.segments, this.cacheName, this.source);
        }
        StateRequestCommand cmd = this.commandsFactory.buildStateRequestCommand(StateRequestCommand.Type.GET_TRANSACTIONS, this.rpcManager.getAddress(), this.topologyId, this.segments);
        Map<Address, Response> responses = this.rpcManager.invokeRemotely(Collections.singleton(this.source), (ReplicableCommand)cmd, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, this.timeout);
        Response response = responses.get(this.source);
        if (response instanceof SuccessfulResponse) {
            List transactions = (List)((SuccessfulResponse)response).getResponseValue();
            this.stateConsumer.applyTransactions(this.source, this.topologyId, transactions);
            return true;
        }
        return false;
    }

    public boolean requestSegments() {
        if (trace) {
            log.tracef("Requesting segments %s of cache %s from node %s", this.segments, this.cacheName, this.source);
        }
        StateRequestCommand cmd = this.commandsFactory.buildStateRequestCommand(StateRequestCommand.Type.START_STATE_TRANSFER, this.rpcManager.getAddress(), this.topologyId, this.segments);
        Map<Address, Response> responses = this.rpcManager.invokeRemotely(Collections.singleton(this.source), (ReplicableCommand)cmd, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, this.timeout);
        Response response = responses.get(this.source);
        return response instanceof SuccessfulResponse;
    }

    public void cancelSegments(Set<Integer> cancelledSegments) {
        if (cancelledSegments.retainAll(this.segments)) {
            throw new IllegalArgumentException("Some of the specified segments cannot be cancelled because they were not previously requested");
        }
        this.segments.removeAll(cancelledSegments);
        this.finishedSegments.removeAll(cancelledSegments);
        if (this.segments.isEmpty()) {
            this.isCancelled = true;
        }
        StateRequestCommand cmd = this.commandsFactory.buildStateRequestCommand(StateRequestCommand.Type.CANCEL_STATE_TRANSFER, this.rpcManager.getAddress(), this.topologyId, cancelledSegments);
        this.rpcManager.invokeRemotely(Collections.singleton(this.source), (ReplicableCommand)cmd, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, this.timeout);
        if (this.isCancelled) {
            this.stateConsumer.onTaskCompletion(this);
        }
    }

    public void cancel() {
        if (!this.isCancelled) {
            this.isCancelled = true;
            StateRequestCommand cmd = this.commandsFactory.buildStateRequestCommand(StateRequestCommand.Type.CANCEL_STATE_TRANSFER, this.rpcManager.getAddress(), this.topologyId, this.segments);
            this.rpcManager.invokeRemotely(Collections.singleton(this.source), (ReplicableCommand)cmd, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, this.timeout);
            this.stateConsumer.onTaskCompletion(this);
        }
    }

    public void onStateReceived(int segmentId, boolean isLastChunk) {
        if (!this.isCancelled && isLastChunk && this.segments.contains(segmentId)) {
            this.finishedSegments.add(segmentId);
            if (this.finishedSegments.containsAll(this.segments)) {
                if (trace) {
                    log.tracef("Finished receiving state for segments %s of cache %s", this.segments, this.cacheName);
                }
                this.stateConsumer.onTaskCompletion(this);
            }
        }
    }

    public String toString() {
        return "InboundTransferTask{segments=" + this.segments + ", finishedSegments=" + this.finishedSegments + ", unfinishedSegments=" + this.getUnfinishedSegments() + ", source=" + this.source + ", isCancelled=" + this.isCancelled + ", topologyId=" + this.topologyId + ", timeout=" + this.timeout + ", cacheName=" + this.cacheName + '}';
    }
}

