/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.CacheException;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class RebalanceConfirmationCollector {
    private static final Log log = LogFactory.getLog(RebalanceConfirmationCollector.class);
    private final String cacheName;
    private final int topologyId;
    private final Set<Address> confirmationsNeeded;

    public RebalanceConfirmationCollector(String cacheName, int topologyId, Collection<Address> members) {
        this.cacheName = cacheName;
        this.topologyId = topologyId;
        this.confirmationsNeeded = new HashSet<Address>(members);
        log.tracef("Initialized rebalance confirmation collector %d@%s, initial list is %s", topologyId, cacheName, this.confirmationsNeeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean confirmRebalance(Address node, int receivedTopologyId) {
        RebalanceConfirmationCollector rebalanceConfirmationCollector = this;
        synchronized (rebalanceConfirmationCollector) {
            if (this.topologyId != receivedTopologyId) {
                throw new CacheException(String.format("Received invalid rebalance confirmation from %s for cache %s, expecting topology id %d but got %d", node, this.cacheName, this.topologyId, receivedTopologyId));
            }
            boolean removed = this.confirmationsNeeded.remove(node);
            if (!removed) {
                log.tracef("Rebalance confirmation collector %d@%s ignored confirmation for %s, which is already confirmed", this.topologyId, this.cacheName, node);
                return false;
            }
            log.tracef("Rebalance confirmation collector %d@%s received confirmation for %s, remaining list is %s", new Object[]{this.topologyId, this.cacheName, node, this.confirmationsNeeded});
            return this.confirmationsNeeded.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateMembers(Collection<Address> newMembers) {
        RebalanceConfirmationCollector rebalanceConfirmationCollector = this;
        synchronized (rebalanceConfirmationCollector) {
            boolean modified = this.confirmationsNeeded.retainAll(newMembers);
            log.tracef("Rebalance confirmation collector %d@%s members list updated, remaining list is %s", this.topologyId, this.cacheName, this.confirmationsNeeded);
            return modified && this.confirmationsNeeded.isEmpty();
        }
    }

    public String toString() {
        return "RebalanceConfirmationCollector{cacheName=" + this.cacheName + "topologyId=" + this.topologyId + ", confirmationsNeeded=" + this.confirmationsNeeded + '}';
    }
}

