/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DataLocality;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Immutables;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseDistributionInterceptor
extends BaseRpcInterceptor {
    protected DistributionManager dm;
    protected CommandsFactory cf;
    protected DataContainer dataContainer;
    protected EntryFactory entryFactory;
    protected LockManager lockManager;
    protected ClusteringDependentLogic cdl;
    private static final Log log = LogFactory.getLog(BaseDistributionInterceptor.class);
    protected static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void injectDependencies(DistributionManager distributionManager, CommandsFactory cf, DataContainer dataContainer, EntryFactory entryFactory, LockManager lockManager, ClusteringDependentLogic cdl) {
        this.dm = distributionManager;
        this.cf = cf;
        this.dataContainer = dataContainer;
        this.entryFactory = entryFactory;
        this.lockManager = lockManager;
        this.cdl = cdl;
    }

    protected boolean needsRemoteGet(InvocationContext ctx, AbstractDataCommand command) {
        CacheEntry entry;
        boolean shouldFetchFromRemote = false;
        if (!(command.hasFlag(Flag.CACHE_MODE_LOCAL) || command.hasFlag(Flag.SKIP_REMOTE_LOOKUP) || command.hasFlag(Flag.IGNORE_RETURN_VALUES) || (entry = ctx.lookupEntry(command.getKey())) != null && !entry.isNull() && !entry.isLockPlaceholder())) {
            Object key = command.getKey();
            DataLocality locality = this.dm.getReadConsistentHash().isKeyLocalToNode(this.rpcManager.getAddress(), key) ? DataLocality.LOCAL : DataLocality.NOT_LOCAL;
            boolean bl = shouldFetchFromRemote = ctx.isOriginLocal() && !locality.isLocal() && !this.dataContainer.containsKey(key);
            if (!shouldFetchFromRemote) {
                log.tracef("Not doing a remote get for key %s since entry is mapped to current node (%s), or is in L1.  Owners are %s", key, this.rpcManager.getAddress(), this.dm.locate(key));
            }
        }
        return shouldFetchFromRemote;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new MultipleKeysRecipientGenerator(command.getMap().keySet()), true, false);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()), false, false);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()), false, false);
    }

    protected abstract Object handleWriteCommand(InvocationContext var1, WriteCommand var2, RecipientGenerator var3, boolean var4, boolean var5) throws Throwable;

    protected boolean isSingleOwnerAndLocal(RecipientGenerator recipientGenerator) {
        List<Address> recipients;
        return this.cacheConfiguration.clustering().hash().numOwners() == 1 && (recipients = recipientGenerator.generateRecipients()) != null && recipients.size() == 1 && recipients.get(0).equals(this.rpcManager.getTransport().getAddress());
    }

    class MultipleKeysRecipientGenerator
    implements RecipientGenerator {
        final Collection<Object> keys;
        List<Address> recipients = null;

        MultipleKeysRecipientGenerator(Collection<Object> keys) {
            this.keys = keys;
        }

        @Override
        public List<Address> generateRecipients() {
            if (this.recipients == null) {
                Set<Address> addresses = BaseDistributionInterceptor.this.dm.locateAll(this.keys);
                this.recipients = Immutables.immutableListConvert(addresses);
            }
            return this.recipients;
        }

        @Override
        public Collection<Object> getKeys() {
            return this.keys;
        }
    }

    class SingleKeyRecipientGenerator
    implements RecipientGenerator {
        final Object key;
        final Set<Object> keys;
        List<Address> recipients = null;

        SingleKeyRecipientGenerator(Object key) {
            this.key = key;
            this.keys = Collections.singleton(key);
        }

        @Override
        public List<Address> generateRecipients() {
            if (this.recipients == null) {
                this.recipients = BaseDistributionInterceptor.this.dm.locate(this.key);
            }
            return this.recipients;
        }

        @Override
        public Collection<Object> getKeys() {
            return this.keys;
        }
    }

    static interface RecipientGenerator
    extends KeyGenerator {
        public List<Address> generateRecipients();
    }

    static interface KeyGenerator {
        public Collection<Object> getKeys();
    }
}

