/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.List;
import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTxDistributionInterceptor
extends BaseDistributionInterceptor {
    private static Log log = LogFactory.getLog(NonTxDistributionInterceptor.class);

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            Object returnValue = this.invokeNextInterceptor(ctx, command);
            if (returnValue == null) {
                Object key = command.getKey();
                if (this.needsRemoteGet(ctx, command)) {
                    returnValue = this.remoteGet(ctx, key, command);
                }
                if (returnValue == null) {
                    returnValue = this.localGet(ctx, key, false, command);
                }
            }
            return returnValue;
        }
        catch (SuspectException e) {
            return this.visitGetKeyValueCommand(ctx, command);
        }
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        BaseDistributionInterceptor.SingleKeyRecipientGenerator skrg = new BaseDistributionInterceptor.SingleKeyRecipientGenerator(command.getKey());
        return this.handleWriteCommand(ctx, command, skrg, command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER), false);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (ctx.isOriginLocal() && !this.isLocalModeForced(command)) {
            this.rpcManager.broadcastRpcCommand(command, this.isSynchronous(command));
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    protected Object handleWriteCommand(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator recipientGenerator, boolean skipRemoteGet, boolean skipL1Invalidation) throws Throwable {
        if (this.isLocalModeForced(command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        if (!ctx.isOriginLocal()) {
            Object returnValue = this.invokeNextInterceptor(ctx, command);
            this.handleRemoteWrite(ctx, command, recipientGenerator, skipL1Invalidation, this.isSynchronous(command));
            return returnValue;
        }
        return this.handleLocalWrite(ctx, command, recipientGenerator, skipL1Invalidation, this.isSynchronous(command));
    }

    protected Object localGet(InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command) throws Throwable {
        InternalCacheEntry ice;
        CacheEntry ce = ctx.lookupEntry(key);
        if ((ce == null || ce.isNull() || ce.isLockPlaceholder() || ce.getValue() == null) && (ice = this.dataContainer.get(key)) != null) {
            if (ce != null && ce.isChanged()) {
                ce.setValue(ice.getValue());
            } else if (isWrite) {
                this.lockAndWrap(ctx, key, ice, command);
            } else {
                ctx.putLookedUpEntry(key, ice);
            }
            return command instanceof GetCacheEntryCommand ? ice : ice.getValue();
        }
        return null;
    }

    private void lockAndWrap(InvocationContext ctx, Object key, InternalCacheEntry ice, FlagAffectedCommand command) throws InterruptedException {
        boolean skipLocking = this.hasSkipLocking(command);
        long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
        this.lockManager.acquireLock(ctx, key, lockTimeout, skipLocking);
        this.entryFactory.wrapEntryForPut(ctx, key, ice, false, command);
    }

    protected Object handleLocalWrite(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator rg, boolean skipL1Invalidation, boolean sync) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!this.isSingleOwnerAndLocal(rg)) {
            List<Address> recipients = rg.generateRecipients();
            if (!command.isSuccessful() && recipients.contains(this.rpcManager.getAddress())) {
                log.trace("Skipping remote invocation as the command hasn't executed correctly on owner");
            } else {
                Address primaryOwner;
                Map<Address, Response> responseMap = this.rpcManager.invokeRemotely(recipients, command, sync);
                if (sync && !recipients.isEmpty() && !(primaryOwner = recipients.get(0)).equals(this.rpcManager.getAddress())) {
                    returnValue = this.getResponseFromPrimaryOwner(primaryOwner, responseMap);
                }
            }
        }
        return returnValue;
    }

    protected void handleRemoteWrite(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator recipientGenerator, boolean skipL1Invalidation, boolean sync) throws Throwable {
    }

    private Object remoteGet(InvocationContext ctx, Object key, GetKeyValueCommand command) throws Throwable {
        if (trace) {
            log.tracef("Doing a remote get for key %s", key);
        }
        InternalCacheEntry ice = this.dm.retrieveFromRemoteSource(key, ctx, false, command);
        command.setRemotelyFetchedValue(ice);
        if (ice != null) {
            return ice.getValue();
        }
        return null;
    }

    protected Object getResponseFromPrimaryOwner(Address primaryOwner, Map<Address, Response> addressResponseMap) {
        if (addressResponseMap.isEmpty() || addressResponseMap.get(primaryOwner) == null) {
            return null;
        }
        Response fromPrimaryOwner = addressResponseMap.get(primaryOwner);
        if (!fromPrimaryOwner.isSuccessful()) {
            throw new CacheException("Got unsuccessful response " + fromPrimaryOwner);
        }
        return ((SuccessfulResponse)fromPrimaryOwner).getResponseValue();
    }
}

