/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.util.concurrent.locks.VisibleOwnerReentrantLock;
import org.infinispan.util.concurrent.locks.containers.AbstractStripedLockContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class ReentrantStripedLockContainer
extends AbstractStripedLockContainer<VisibleOwnerReentrantLock> {
    private VisibleOwnerReentrantLock[] sharedLocks;
    private static final Log log = LogFactory.getLog(ReentrantStripedLockContainer.class);

    @Override
    protected Log getLog() {
        return log;
    }

    public ReentrantStripedLockContainer(int concurrencyLevel) {
        this.initLocks(this.calculateNumberOfSegments(concurrencyLevel));
    }

    @Override
    protected void initLocks(int numLocks) {
        this.sharedLocks = new VisibleOwnerReentrantLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this.sharedLocks[i] = new VisibleOwnerReentrantLock();
        }
    }

    @Override
    public final VisibleOwnerReentrantLock getLock(Object object) {
        return this.sharedLocks[this.hashToIndex(object)];
    }

    @Override
    public final int getNumLocksHeld() {
        int i = 0;
        for (VisibleOwnerReentrantLock l : this.sharedLocks) {
            if (!l.isLocked()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public int size() {
        return this.sharedLocks.length;
    }

    @Override
    public final boolean ownsLock(Object object, Object ignored) {
        VisibleOwnerReentrantLock lock = this.getLock(object);
        return lock.isHeldByCurrentThread();
    }

    @Override
    public final boolean isLocked(Object object) {
        VisibleOwnerReentrantLock lock = this.getLock(object);
        return lock.isLocked();
    }

    public String toString() {
        return "ReentrantStripedLockContainer{sharedLocks=" + (this.sharedLocks == null ? null : Arrays.asList(this.sharedLocks)) + '}';
    }

    @Override
    protected void unlock(VisibleOwnerReentrantLock l, Object unused) {
        l.unlock();
    }

    @Override
    protected boolean tryLock(VisibleOwnerReentrantLock lock, long timeout, TimeUnit unit, Object unused) throws InterruptedException {
        return lock.tryLock(timeout, unit);
    }

    @Override
    protected void lock(VisibleOwnerReentrantLock lock, Object lockOwner) {
        lock.lock();
    }
}

