/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.AbstractFlagAffectedCommand;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class PutMapCommand
extends AbstractFlagAffectedCommand
implements WriteCommand,
MetadataAwareCommand {
    public static final byte COMMAND_ID = 9;
    Map<Object, Object> map;
    CacheNotifier notifier;
    Metadata metadata;
    boolean isForwarded = false;

    public PutMapCommand() {
    }

    public PutMapCommand(Map<?, ?> map, CacheNotifier notifier, Metadata metadata, Set<Flag> flags) {
        this.map = map;
        this.notifier = notifier;
        this.metadata = metadata;
        this.flags = flags;
    }

    public void init(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutMapCommand(ctx, this);
    }

    private MVCCEntry lookupMvccEntry(InvocationContext ctx, Object key) {
        return (MVCCEntry)ctx.lookupEntry(key);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        HashMap previousValues = new HashMap();
        for (Map.Entry<Object, Object> e : this.map.entrySet()) {
            Object key = e.getKey();
            MVCCEntry me = this.lookupMvccEntry(ctx, key);
            if (me == null) continue;
            Object value = me.getValue();
            previousValues.put(key, value);
            this.notifier.notifyCacheEntryModified(key, e.getValue(), value, me.getMetadata(), true, ctx, this);
            me.setValue(e.getValue());
            me.setChanged(true);
        }
        return previousValues;
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    public void setMap(Map<Object, Object> map) {
        this.map = map;
    }

    @Override
    public byte getCommandId() {
        return 9;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.map, this.metadata, this.isForwarded, Flag.copyWithoutRemotableFlags(this.flags)};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        this.map = (Map)parameters[0];
        this.metadata = (Metadata)parameters[1];
        this.isForwarded = (Boolean)parameters[2];
        if (parameters.length > 3) {
            this.flags = (Set)parameters[3];
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutMapCommand that = (PutMapCommand)o;
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.map != null ? !this.map.equals(that.map) : that.map != null);
    }

    public int hashCode() {
        int result = this.map != null ? this.map.hashCode() : 0;
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PutMapCommand{map={");
        if (!this.map.isEmpty()) {
            Iterator<Map.Entry<Object, Object>> it = this.map.entrySet().iterator();
            int i = 0;
            while (true) {
                Map.Entry<Object, Object> e = it.next();
                sb.append(e.getKey()).append('=').append(e.getValue());
                if (!it.hasNext()) break;
                if (i > 100) {
                    sb.append(" ...");
                    break;
                }
                sb.append(", ");
                ++i;
            }
        }
        sb.append("}, flags=").append(this.flags).append(", metadata=").append(this.metadata).append(", isForwarded=").append(this.isForwarded).append("}");
        return sb.toString();
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public Set<Object> getAffectedKeys() {
        return this.map.keySet();
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean isForwarded() {
        return this.isForwarded;
    }

    public void setForwarded(boolean forwarded) {
        this.isForwarded = forwarded;
    }
}

