/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collections;
import java.util.Set;

public class AuthorizationConfiguration {
    private final boolean enabled;
    private final Set<String> roles;

    AuthorizationConfiguration(boolean enabled, Set<String> roles) {
        this.enabled = enabled;
        this.roles = Collections.unmodifiableSet(roles);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Set<String> roles() {
        return this.roles;
    }

    public String toString() {
        return "AuthorizationConfiguration [enabled=" + this.enabled + ", roles=" + this.roles + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationConfiguration other = (AuthorizationConfiguration)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        return !(this.roles == null ? other.roles != null : !this.roles.equals(other.roles));
    }
}

