/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.util.concurrent.locks.VisibleOwnerRefCountingReentrantLock;
import org.infinispan.util.concurrent.locks.containers.AbstractPerEntryLockContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReentrantPerEntryLockContainer
extends AbstractPerEntryLockContainer<VisibleOwnerRefCountingReentrantLock> {
    private static final Log log = LogFactory.getLog(ReentrantPerEntryLockContainer.class);

    @Override
    protected Log getLog() {
        return log;
    }

    public ReentrantPerEntryLockContainer(int concurrencyLevel, Equivalence<Object> keyEquivalence) {
        super(concurrencyLevel, keyEquivalence);
    }

    @Override
    protected VisibleOwnerRefCountingReentrantLock newLock() {
        return new VisibleOwnerRefCountingReentrantLock();
    }

    @Override
    public boolean ownsLock(Object key, Object ignored) {
        ReentrantLock l = this.getLockFromMap(key);
        return l != null && l.isHeldByCurrentThread();
    }

    @Override
    public boolean isLocked(Object key) {
        ReentrantLock l = this.getLockFromMap(key);
        return l != null && l.isLocked();
    }

    private ReentrantLock getLockFromMap(Object key) {
        return (ReentrantLock)this.locks.get(key);
    }

    @Override
    protected void unlock(VisibleOwnerRefCountingReentrantLock l, Object unused) {
        l.unlock();
    }

    @Override
    protected boolean tryLock(VisibleOwnerRefCountingReentrantLock lock, long timeout, TimeUnit unit, Object unused) throws InterruptedException {
        return lock.tryLock(timeout, unit);
    }

    @Override
    protected void lock(VisibleOwnerRefCountingReentrantLock lock, Object lockOwner) {
        lock.lock();
    }
}

