/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.concurrent.NotifyingNotifiableFuture;

public class CompletableFutures {
    private static final CompletableFuture completedEmptyMapFuture = CompletableFuture.completedFuture(InfinispanCollections.emptyMap());

    public static <K, V> CompletableFuture<Map<K, V>> returnEmptyMap() {
        return completedEmptyMapFuture;
    }

    public static <T> void connect(NotifyingNotifiableFuture<T> sink, CompletableFuture<T> source) {
        CompletionStage compoundSource = source.whenComplete((value, throwable) -> {
            if (throwable == null) {
                sink.notifyDone(value);
            } else {
                sink.notifyException(throwable);
            }
        });
        sink.setFuture((Future)((Object)compoundSource));
    }

    public static boolean await(CompletableFuture<?> future, long time, TimeUnit unit) throws InterruptedException {
        try {
            Objects.requireNonNull(future, "Completable Future must be non-null.").get(time, Objects.requireNonNull(unit, "Time Unit must be non-null"));
            return true;
        }
        catch (ExecutionException e) {
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }
}

