/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoveExpiredCommand
extends RemoveCommand {
    public static final int COMMAND_ID = 58;
    private static final Log log = LogFactory.getLog(RemoveExpiredCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    protected Long lifespan;
    protected TimeService timeService;

    public RemoveExpiredCommand() {
        this.valueMatcher = ValueMatcher.MATCH_EXPECTED_OR_NULL;
    }

    public RemoveExpiredCommand(Object key, Object value, Long lifespan, CacheNotifier notifier, Equivalence valueEquivalence, TimeService timeService, CommandInvocationId commandInvocationId) {
        super(key, value, notifier, null, valueEquivalence, commandInvocationId);
        this.lifespan = lifespan;
        this.timeService = timeService;
        this.valueMatcher = ValueMatcher.MATCH_EXPECTED_OR_NULL;
    }

    public void init(CacheNotifier notifier, Configuration configuration, TimeService timeService) {
        super.init(notifier, configuration);
        this.timeService = timeService;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e != null && !e.isRemoved()) {
            Object value = e.getValue();
            if (this.lifespan == null) {
                if (this.valueMatcher.matches(e, value, e.getValue(), this.valueEquivalence)) {
                    e.setExpired(true);
                    return this.performRemove(e, ctx);
                }
            } else if (e.getMetadata() == null) {
                if (value == null || this.valueMatcher.matches(e, value, e.getValue(), this.valueEquivalence)) {
                    e.setExpired(true);
                    return this.performRemove(e, ctx);
                }
            } else if (e.getLifespan() > 0L && e.getLifespan() == this.lifespan.longValue()) {
                if (this.valueMatcher.matches(e, value, e.getValue(), this.valueEquivalence)) {
                    e.setExpired(true);
                    return this.performRemove(e, ctx);
                }
            } else {
                log.trace("Cannot remove entry as its lifespan or value do not match");
            }
        } else {
            log.trace("Nothing to remove since the entry doesn't exist in the context or it is already removed");
        }
        this.successful = false;
        return false;
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public void notify(InvocationContext ctx, Object removedValue, Metadata removedMetadata, boolean isPre) {
        if (!isPre) {
            this.notifier.notifyCacheEntryExpired(this.key, this.value, removedMetadata, ctx);
        }
    }

    @Override
    public byte getCommandId() {
        return 58;
    }

    @Override
    public String toString() {
        return "RemoveExpiredCommand{key=" + this.key + "value=" + this.value + "lifespan=" + this.lifespan + '}';
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.commandInvocationId);
        output.writeObject(this.key);
        output.writeObject(this.value);
        output.writeLong(this.lifespan);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = (CommandInvocationId)input.readObject();
        this.key = input.readObject();
        this.value = input.readObject();
        this.lifespan = input.readLong();
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        switch (status) {
            case FAILED: 
            case STOPPING: 
            case TERMINATED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoveExpiredCommand that = (RemoveExpiredCommand)o;
        return Objects.equals(this.lifespan, that.lifespan);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lifespan);
    }

    @Override
    public Set<Flag> getFlags() {
        return EnumSet.of(Flag.SKIP_CACHE_LOAD);
    }

    @Override
    public boolean hasFlag(Flag flag) {
        return flag == Flag.SKIP_CACHE_LOAD;
    }
}

