/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.remoting.transport.Address;

public final class SingleKeyNonTxInvocationContext
implements InvocationContext {
    private boolean isLocked;
    private Object key;
    private CacheEntry cacheEntry;
    private final Equivalence keyEquivalence;
    private ClassLoader classLoader;
    private final Address origin;
    private Object lockOwner;

    public SingleKeyNonTxInvocationContext(Address origin, Equivalence<Object> keyEquivalence) {
        this.origin = origin;
        this.keyEquivalence = keyEquivalence;
    }

    @Override
    public boolean isOriginLocal() {
        return this.origin == null;
    }

    @Override
    public boolean isInTxScope() {
        return false;
    }

    @Override
    public Object getLockOwner() {
        return this.lockOwner;
    }

    @Override
    public void setLockOwner(Object lockOwner) {
        this.lockOwner = lockOwner;
    }

    @Override
    public Set<Object> getLockedKeys() {
        return this.isLocked ? Collections.singleton(this.key) : Collections.emptySet();
    }

    @Override
    public void clearLockedKeys() {
        this.isLocked = false;
        this.cacheEntry = null;
    }

    @Override
    public void addLockedKey(Object key) {
        if (this.key == null) {
            this.key = key;
        } else if (!this.keyEquivalence.equals(key, this.key)) {
            throw this.illegalStateException();
        }
        this.isLocked = true;
    }

    private IllegalStateException illegalStateException() {
        return new IllegalStateException("This is a single key invocation context, using multiple keys shouldn't be possible");
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        if (key != null && this.key != null && this.keyEquivalence.equals(key, this.key)) {
            return this.cacheEntry;
        }
        return null;
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.cacheEntry == null ? Collections.emptyMap() : Collections.singletonMap(this.key, this.cacheEntry);
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        if (this.key == null) {
            this.key = key;
        } else if (!this.keyEquivalence.equals(key, this.key)) {
            throw this.illegalStateException();
        }
        this.cacheEntry = e;
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        if (this.keyEquivalence.equals(key, this.key)) {
            this.cacheEntry = null;
        }
    }

    public Object getKey() {
        return this.key;
    }

    public CacheEntry getCacheEntry() {
        return this.cacheEntry;
    }

    @Override
    public Address getOrigin() {
        return this.origin;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public boolean hasLockedKey(Object key) {
        return this.isLocked && this.keyEquivalence.equals(this.key, key);
    }

    @Override
    public boolean isEntryRemovedInContext(Object key) {
        CacheEntry ce = this.lookupEntry(key);
        return ce != null && ce.isRemoved() && ce.isChanged();
    }

    @Override
    public SingleKeyNonTxInvocationContext clone() {
        try {
            return (SingleKeyNonTxInvocationContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!");
        }
    }

    public void resetState() {
        this.key = null;
        this.cacheEntry = null;
        this.isLocked = false;
    }
}

