/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LongSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.stream.impl.AbstractCacheStream;
import org.infinispan.stream.impl.DistributedCacheStream;
import org.infinispan.stream.impl.DistributedDoubleCacheStream;
import org.infinispan.stream.impl.DistributedIntCacheStream;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.TerminalFunctions;
import org.infinispan.stream.impl.intops.primitive.l.AsDoubleLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.BoxedLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.DistinctLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.FilterLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.FlatMapLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.LimitLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapToDoubleLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapToIntLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapToObjLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.PeekLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.SortedLongOperation;
import org.infinispan.stream.impl.termop.primitive.ForEachFlatMapLongOperation;
import org.infinispan.stream.impl.termop.primitive.ForEachLongOperation;

public class DistributedLongCacheStream
extends AbstractCacheStream<Long, LongStream, LongConsumer>
implements LongStream {
    protected DistributedLongCacheStream(AbstractCacheStream other) {
        super(other);
    }

    @Override
    protected LongStream unwrap() {
        return this;
    }

    @Override
    public LongStream filter(LongPredicate predicate) {
        return this.addIntermediateOperation(new FilterLongOperation(predicate));
    }

    @Override
    public LongStream map(LongUnaryOperator mapper) {
        return this.addIntermediateOperation(new MapLongOperation(mapper));
    }

    @Override
    public <U> Stream<U> mapToObj(LongFunction<? extends U> mapper) {
        return this.addIntermediateOperationMap(new MapToObjLongOperation<U>(mapper), this.cacheStream());
    }

    @Override
    public IntStream mapToInt(LongToIntFunction mapper) {
        return this.addIntermediateOperationMap(new MapToIntLongOperation(mapper), this.intCacheStream());
    }

    @Override
    public DoubleStream mapToDouble(LongToDoubleFunction mapper) {
        return this.addIntermediateOperationMap(new MapToDoubleLongOperation(mapper), this.doubleCacheStream());
    }

    @Override
    public LongStream flatMap(LongFunction<? extends LongStream> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        return this.addIntermediateOperation(new FlatMapLongOperation(mapper));
    }

    @Override
    public LongStream distinct() {
        DistinctLongOperation op = DistinctLongOperation.getInstance();
        this.markDistinct(op, AbstractCacheStream.IntermediateType.LONG);
        return this.addIntermediateOperation(op);
    }

    @Override
    public LongStream sorted() {
        this.markSorted(AbstractCacheStream.IntermediateType.LONG);
        return this.addIntermediateOperation(SortedLongOperation.getInstance());
    }

    @Override
    public LongStream peek(LongConsumer action) {
        return this.addIntermediateOperation(new PeekLongOperation(action));
    }

    @Override
    public DoubleStream asDoubleStream() {
        return this.addIntermediateOperationMap(AsDoubleLongOperation.getInstance(), this.doubleCacheStream());
    }

    @Override
    public Stream<Long> boxed() {
        return this.addIntermediateOperationMap(BoxedLongOperation.getInstance(), this.cacheStream());
    }

    @Override
    public LongStream limit(long maxSize) {
        LimitLongOperation op = new LimitLongOperation(maxSize);
        this.markDistinct(op, AbstractCacheStream.IntermediateType.LONG);
        return this.addIntermediateOperation(op);
    }

    @Override
    public LongStream skip(long n) {
        LimitLongOperation op = new LimitLongOperation(n);
        this.markSkip(AbstractCacheStream.IntermediateType.LONG);
        return this.addIntermediateOperation(op);
    }

    @Override
    public void forEach(LongConsumer action) {
        if (!this.rehashAware) {
            this.performOperation(TerminalFunctions.forEachFunction(action), false, (v1, v2) -> null, null);
        } else {
            this.performRehashForEach(action);
        }
    }

    @Override
    KeyTrackingTerminalOperation<Object, Long, Object> getForEach(LongConsumer consumer, Supplier<Stream<CacheEntry>> supplier) {
        if (this.iteratorOperation == AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            return new ForEachFlatMapLongOperation<Object>(this.intermediateOperations, supplier, this.distributedBatchSize, consumer);
        }
        return new ForEachLongOperation<Object>(this.intermediateOperations, supplier, this.distributedBatchSize, consumer);
    }

    @Override
    public void forEachOrdered(LongConsumer action) {
        if (this.intermediateType.shouldUseIntermediate(this.sorted, this.distinct)) {
            this.performIntermediateRemoteOperation(s -> {
                s.forEachOrdered(action);
                return null;
            });
        } else {
            this.forEach(action);
        }
    }

    @Override
    public long[] toArray() {
        return this.performOperation(TerminalFunctions.toArrayLongFunction(), false, (v1, v2) -> {
            long[] array = Arrays.copyOf(v1, ((long[])v1).length + ((long[])v2).length);
            System.arraycopy(v2, 0, array, ((long[])v1).length, ((long[])v2).length);
            return array;
        }, null, false);
    }

    @Override
    public long reduce(long identity, LongBinaryOperator op) {
        return this.performOperation(TerminalFunctions.reduceFunction(identity, op), true, (i1, i2) -> op.applyAsLong((long)i1, (long)i2), null);
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator op) {
        Long result = this.performOperation(TerminalFunctions.reduceFunction(op), true, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return op.applyAsLong((long)i1, (long)i2);
                }
                return i1;
            }
            return i2;
        }, null);
        if (result == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(result);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.performOperation(TerminalFunctions.collectFunction(supplier, accumulator, combiner), true, (e1, e2) -> {
            combiner.accept(e1, e2);
            return e1;
        }, null);
    }

    @Override
    public long sum() {
        return this.performOperation(TerminalFunctions.sumLongFunction(), true, (i1, i2) -> i1 + i2, null);
    }

    @Override
    public OptionalLong min() {
        Long value = this.performOperation(TerminalFunctions.minLongFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return i1 > i2 ? i2 : i1;
                }
                return i1;
            }
            return i2;
        }, null);
        if (value == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(value);
    }

    @Override
    public OptionalLong max() {
        Long value = this.performOperation(TerminalFunctions.maxLongFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return i1 > i2 ? i1 : i2;
                }
                return i1;
            }
            return i2;
        }, null);
        if (value == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(value);
    }

    @Override
    public OptionalDouble average() {
        long[] results = this.performOperation(TerminalFunctions.averageLongFunction(), true, (a1, a2) -> {
            a1[0] = a1[0] + a2[0];
            a1[1] = a1[1] + a2[1];
            return a1;
        }, null);
        if (results[1] > 0L) {
            return OptionalDouble.of((double)results[0] / (double)results[1]);
        }
        return OptionalDouble.empty();
    }

    @Override
    public LongSummaryStatistics summaryStatistics() {
        return this.performOperation(TerminalFunctions.summaryStatisticsLongFunction(), true, (ls1, ls2) -> {
            ls1.combine((LongSummaryStatistics)ls2);
            return ls1;
        }, null);
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        return this.performOperation(TerminalFunctions.anyMatchFunction(predicate), false, Boolean::logicalOr, b -> b);
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        return this.performOperation(TerminalFunctions.allMatchFunction(predicate), false, Boolean::logicalAnd, b -> b == false);
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        return this.performOperation(TerminalFunctions.noneMatchFunction(predicate), false, Boolean::logicalAnd, b -> b == false);
    }

    @Override
    public OptionalLong findFirst() {
        if (this.intermediateType.shouldUseIntermediate(this.sorted, this.distinct)) {
            return this.performIntermediateRemoteOperation(s -> s.findFirst());
        }
        return this.findAny();
    }

    @Override
    public OptionalLong findAny() {
        Long result = this.performOperation(TerminalFunctions.findAnyLongFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                return i1;
            }
            return i2;
        }, null);
        if (result != null) {
            return OptionalLong.of(result);
        }
        return OptionalLong.empty();
    }

    @Override
    public PrimitiveIterator.OfLong iterator() {
        if (this.intermediateType.shouldUseIntermediate(this.sorted, this.distinct)) {
            LongStream stream = (LongStream)this.performIntermediateRemoteOperation(Function.identity());
            return stream.iterator();
        }
        return this.remoteIterator();
    }

    PrimitiveIterator.OfLong remoteIterator() {
        this.intermediateOperations.add(BoxedLongOperation.getInstance());
        DistributedCacheStream stream = new DistributedCacheStream((AbstractCacheStream)this);
        Iterator<Long> iterator = stream.remoteIterator();
        return new LongIteratorToPrimitiveLong(iterator);
    }

    @Override
    public Spliterator.OfLong spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 0);
    }

    @Override
    public long count() {
        return this.performOperation(TerminalFunctions.countLongFunction(), true, (i1, i2) -> i1 + i2, null);
    }

    protected <R> DistributedCacheStream<R> cacheStream() {
        return new DistributedCacheStream((AbstractCacheStream)this);
    }

    protected DistributedDoubleCacheStream doubleCacheStream() {
        return new DistributedDoubleCacheStream((AbstractCacheStream)this);
    }

    protected DistributedIntCacheStream intCacheStream() {
        return new DistributedIntCacheStream((AbstractCacheStream)this);
    }

    static class LongIteratorToPrimitiveLong
    implements PrimitiveIterator.OfLong {
        private final Iterator<Long> iterator;

        LongIteratorToPrimitiveLong(Iterator<Long> iterator) {
            this.iterator = iterator;
        }

        @Override
        public long nextLong() {
            return this.iterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

