/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationChildBuilder;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfigurationBuilder;
import org.infinispan.configuration.global.GlobalSecurityConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStateConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownConfigurationBuilder;
import org.infinispan.configuration.global.SiteConfigurationBuilder;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;

public class GlobalConfigurationBuilder
implements GlobalConfigurationChildBuilder {
    private WeakReference<ClassLoader> cl;
    private final TransportConfigurationBuilder transport;
    private final GlobalJmxStatisticsConfigurationBuilder globalJmxStatistics;
    private final SerializationConfigurationBuilder serialization;
    private final GlobalSecurityConfigurationBuilder security;
    private final ThreadPoolConfigurationBuilder expirationThreadPool;
    private final ThreadPoolConfigurationBuilder listenerThreadPool;
    private final ThreadPoolConfigurationBuilder replicationQueueThreadPool;
    private final ThreadPoolConfigurationBuilder persistenceThreadPool;
    private final ThreadPoolConfigurationBuilder stateTransferThreadPool;
    private final ThreadPoolConfigurationBuilder asyncThreadPool;
    private final ShutdownConfigurationBuilder shutdown;
    private final GlobalStateConfigurationBuilder globalState;
    private final List<Builder<?>> modules = new ArrayList();
    private final SiteConfigurationBuilder site;

    public GlobalConfigurationBuilder() {
        ClassLoader defaultCL = Util.isOSGiContext() ? GlobalConfigurationBuilder.class.getClassLoader() : Thread.currentThread().getContextClassLoader();
        this.cl = new WeakReference<ClassLoader>(defaultCL);
        this.transport = new TransportConfigurationBuilder(this);
        this.globalJmxStatistics = new GlobalJmxStatisticsConfigurationBuilder(this);
        this.serialization = new SerializationConfigurationBuilder(this);
        this.security = new GlobalSecurityConfigurationBuilder(this);
        this.shutdown = new ShutdownConfigurationBuilder(this);
        this.globalState = new GlobalStateConfigurationBuilder(this);
        this.site = new SiteConfigurationBuilder(this);
        this.expirationThreadPool = new ThreadPoolConfigurationBuilder(this);
        this.listenerThreadPool = new ThreadPoolConfigurationBuilder(this);
        this.replicationQueueThreadPool = new ThreadPoolConfigurationBuilder(this);
        this.persistenceThreadPool = new ThreadPoolConfigurationBuilder(this);
        this.stateTransferThreadPool = new ThreadPoolConfigurationBuilder(this);
        this.asyncThreadPool = new ThreadPoolConfigurationBuilder(this);
    }

    public GlobalConfigurationBuilder clusteredDefault() {
        this.transport().defaultTransport().clearProperties();
        return this;
    }

    public GlobalConfigurationBuilder nonClusteredDefault() {
        this.transport().transport(null).clearProperties();
        return this;
    }

    protected ClassLoader getClassLoader() {
        return (ClassLoader)this.cl.get();
    }

    public GlobalConfigurationBuilder classLoader(ClassLoader cl) {
        this.cl = new WeakReference<ClassLoader>(cl);
        return this;
    }

    @Override
    public TransportConfigurationBuilder transport() {
        return this.transport;
    }

    @Override
    public GlobalJmxStatisticsConfigurationBuilder globalJmxStatistics() {
        return this.globalJmxStatistics;
    }

    @Override
    public SerializationConfigurationBuilder serialization() {
        return this.serialization;
    }

    @Override
    @Deprecated
    public ThreadPoolConfigurationBuilder evictionThreadPool() {
        return this.expirationThreadPool;
    }

    @Override
    public ThreadPoolConfigurationBuilder expirationThreadPool() {
        return this.expirationThreadPool;
    }

    @Override
    public ThreadPoolConfigurationBuilder listenerThreadPool() {
        return this.listenerThreadPool;
    }

    @Override
    @Deprecated
    public ThreadPoolConfigurationBuilder replicationQueueThreadPool() {
        return this.replicationQueueThreadPool;
    }

    @Override
    public ThreadPoolConfigurationBuilder persistenceThreadPool() {
        return this.persistenceThreadPool;
    }

    @Override
    public ThreadPoolConfigurationBuilder stateTransferThreadPool() {
        return this.stateTransferThreadPool;
    }

    @Override
    public ThreadPoolConfigurationBuilder asyncThreadPool() {
        return this.asyncThreadPool;
    }

    @Override
    public GlobalSecurityConfigurationBuilder security() {
        return this.security;
    }

    @Override
    public ShutdownConfigurationBuilder shutdown() {
        return this.shutdown;
    }

    public List<Builder<?>> modules() {
        return this.modules;
    }

    public GlobalConfigurationBuilder clearModules() {
        this.modules.clear();
        return this;
    }

    @Override
    public SiteConfigurationBuilder site() {
        return this.site;
    }

    public <T extends Builder<?>> T addModule(Class<T> klass) {
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(GlobalConfigurationBuilder.class);
            Builder builder = (Builder)constructor.newInstance(this);
            this.modules.add(builder);
            return (T)builder;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Could not instantiate module configuration builder '" + klass.getName() + "'", (Throwable)e);
        }
    }

    @Override
    public GlobalStateConfigurationBuilder globalState() {
        return this.globalState;
    }

    public void validate() {
        Arrays.asList(this.expirationThreadPool, this.listenerThreadPool, this.replicationQueueThreadPool, this.persistenceThreadPool, this.stateTransferThreadPool, this.asyncThreadPool, this.globalJmxStatistics, this.transport, this.security, this.serialization, this.shutdown, this.globalState, this.site).forEach(c -> ((Builder)c).validate());
        this.modules.forEach(c -> c.validate());
    }

    @Override
    public GlobalConfiguration build() {
        this.validate();
        LinkedList<Object> modulesConfig = new LinkedList<Object>();
        for (Builder<?> module : this.modules) {
            modulesConfig.add(module.create());
        }
        return new GlobalConfiguration(this.expirationThreadPool.create(), this.listenerThreadPool.create(), this.replicationQueueThreadPool.create(), this.persistenceThreadPool.create(), this.stateTransferThreadPool.create(), this.asyncThreadPool.create(), this.globalJmxStatistics.create(), this.transport.create(), this.security.create(), this.serialization.create(), this.shutdown.create(), this.globalState.create(), modulesConfig, this.site.create(), (ClassLoader)this.cl.get());
    }

    public GlobalConfigurationBuilder read(GlobalConfiguration template) {
        this.cl = new WeakReference<ClassLoader>(template.classLoader());
        for (Object c : template.modules().values()) {
            BuiltBy builtBy = c.getClass().getAnnotation(BuiltBy.class);
            Object builder = this.addModule(builtBy.value());
            builder.read(c);
        }
        this.expirationThreadPool.read(template.expirationThreadPool());
        this.listenerThreadPool.read(template.listenerThreadPool());
        this.replicationQueueThreadPool.read(template.replicationQueueThreadPool());
        this.persistenceThreadPool.read(template.persistenceThreadPool());
        this.stateTransferThreadPool.read(template.stateTransferThreadPool());
        this.asyncThreadPool.read(template.asyncThreadPool());
        this.globalJmxStatistics.read(template.globalJmxStatistics());
        this.security.read(template.security());
        this.serialization.read(template.serialization());
        this.shutdown.read(template.shutdown());
        this.globalState.read(template.globalState());
        this.transport.read(template.transport());
        this.site.read(template.sites());
        return this;
    }

    public static GlobalConfigurationBuilder defaultClusteredBuilder() {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.transport().defaultTransport();
        return builder;
    }

    public String toString() {
        return "GlobalConfigurationBuilder{expirationThreadPool=" + this.expirationThreadPool + ", listenerExecutorThreadPool=" + this.listenerThreadPool + ", cl=" + this.cl + ", transport=" + this.transport + ", globalJmxStatistics=" + this.globalJmxStatistics + ", serialization=" + this.serialization + ", replicationQueueThreadPool=" + this.replicationQueueThreadPool + ", persistenceThreadPool=" + this.persistenceThreadPool + ", stateTransferThreadPool=" + this.stateTransferThreadPool + ", asyncThreadPool=" + this.asyncThreadPool + ", security=" + this.security + ", shutdown=" + this.shutdown + ", globalState=" + this.globalState + ", site=" + this.site + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalConfigurationBuilder that = (GlobalConfigurationBuilder)o;
        if (!this.expirationThreadPool.equals(that.expirationThreadPool)) {
            return false;
        }
        if (!this.listenerThreadPool.equals(that.listenerThreadPool)) {
            return false;
        }
        if (!this.replicationQueueThreadPool.equals(that.replicationQueueThreadPool)) {
            return false;
        }
        if (!this.persistenceThreadPool.equals(that.persistenceThreadPool)) {
            return false;
        }
        if (!this.stateTransferThreadPool.equals(that.stateTransferThreadPool)) {
            return false;
        }
        if (!this.asyncThreadPool.equals(that.asyncThreadPool)) {
            return false;
        }
        if (this.cl != null ? !this.cl.equals(that.cl) : that.cl != null) {
            return false;
        }
        if (!this.globalJmxStatistics.equals(that.globalJmxStatistics)) {
            return false;
        }
        if (!this.serialization.equals(that.serialization)) {
            return false;
        }
        if (!this.shutdown.equals(that.shutdown)) {
            return false;
        }
        if (!this.site.equals(that.site)) {
            return false;
        }
        if (!this.security.equals(that.security)) {
            return false;
        }
        if (!this.globalState.equals(that.globalState)) {
            return false;
        }
        return !this.transport.equals(that.transport);
    }

    public int hashCode() {
        int result = this.cl != null ? this.cl.hashCode() : 0;
        result = 31 * result + this.transport.hashCode();
        result = 31 * result + this.globalJmxStatistics.hashCode();
        result = 31 * result + this.serialization.hashCode();
        result = 31 * result + this.expirationThreadPool.hashCode();
        result = 31 * result + this.listenerThreadPool.hashCode();
        result = 31 * result + this.replicationQueueThreadPool.hashCode();
        result = 31 * result + this.persistenceThreadPool.hashCode();
        result = 31 * result + this.stateTransferThreadPool.hashCode();
        result = 31 * result + this.asyncThreadPool.hashCode();
        result = 31 * result + this.shutdown.hashCode();
        result = 31 * result + this.site.hashCode();
        result = 31 * result + this.security.hashCode();
        result = 31 * result + this.globalState.hashCode();
        return result;
    }
}

