/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;

public final class ParseUtils {
    private ParseUtils() {
    }

    public static Element nextElement(XMLStreamReader reader) throws XMLStreamException {
        if (reader.nextTag() == 2) {
            return null;
        }
        return Element.forName(reader.getLocalName());
    }

    public static XMLStreamException unexpectedElement(XMLStreamReader reader) {
        return new XMLStreamException("Unexpected element '" + reader.getName() + "' encountered", reader.getLocation());
    }

    public static XMLStreamException unexpectedEndElement(XMLStreamReader reader) {
        return new XMLStreamException("Unexpected end of element '" + reader.getName() + "' encountered", reader.getLocation());
    }

    public static XMLStreamException unexpectedAttribute(XMLStreamReader reader, int index) {
        return new XMLStreamException("Unexpected attribute '" + reader.getAttributeName(index) + "' encountered", reader.getLocation());
    }

    public static XMLStreamException unexpectedAttribute(XMLStreamReader reader, String name) {
        return new XMLStreamException("Unexpected attribute '" + name + "' encountered", reader.getLocation());
    }

    public static XMLStreamException invalidAttributeValue(XMLStreamReader reader, int index) {
        return new XMLStreamException("Invalid value '" + reader.getAttributeValue(index) + "' for attribute '" + reader.getAttributeName(index) + "'", reader.getLocation());
    }

    public static XMLStreamException missingRequired(XMLStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return new XMLStreamException("Missing required attribute(s): " + b, reader.getLocation());
    }

    public static XMLStreamException missingRequiredElement(XMLStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return new XMLStreamException("Missing required element(s): " + b, reader.getLocation());
    }

    public static void requireNoAttributes(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute(reader, 0);
        }
    }

    public static void requireNoContent(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    public static XMLStreamException duplicateAttribute(XMLStreamReader reader, String name) {
        return new XMLStreamException("An attribute named '" + name + "' has already been declared", reader.getLocation());
    }

    public static XMLStreamException duplicateNamedElement(XMLStreamReader reader, String name) {
        return new XMLStreamException("An element of this type named '" + name + "' has already been declared", reader.getLocation());
    }

    public static boolean readBooleanAttributeElement(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        boolean value = Boolean.parseBoolean(reader.getAttributeValue(0));
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static String readStringAttributeElement(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        String value = reader.getAttributeValue(0);
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static String requireSingleAttribute(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count == 0) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(attributeName));
        }
        ParseUtils.requireNoNamespaceAttribute(reader, 0);
        if (!attributeName.equals(reader.getAttributeLocalName(0))) {
            throw ParseUtils.unexpectedAttribute(reader, 0);
        }
        if (count > 1) {
            throw ParseUtils.unexpectedAttribute(reader, 1);
        }
        return reader.getAttributeValue(0);
    }

    public static String[] requireAttributes(XMLStreamReader reader, String ... attributeNames) throws XMLStreamException {
        int length = attributeNames.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            String name = attributeNames[i];
            String value = reader.getAttributeValue(null, name);
            if (value == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(name));
            }
            result[i] = value;
        }
        return result;
    }

    public static boolean isNoNamespaceAttribute(XMLStreamReader reader, int index) {
        String namespace = reader.getAttributeNamespace(index);
        return namespace == null || "".equals(namespace);
    }

    public static void requireNoNamespaceAttribute(XMLStreamReader reader, int index) throws XMLStreamException {
        if (!ParseUtils.isNoNamespaceAttribute(reader, index)) {
            throw ParseUtils.unexpectedAttribute(reader, index);
        }
    }

    public static String getWarningMessage(String msg, Location location) {
        return String.format("Parsing problem at [row,col]:[%d ,%d]%nMessage: %s%n", location.getLineNumber(), location.getColumnNumber(), msg);
    }

    public static Namespace[] getNamespaceAnnotations(Class<?> cls) {
        Namespaces namespacesAnnotation = cls.getAnnotation(Namespaces.class);
        if (namespacesAnnotation != null) {
            return namespacesAnnotation.value();
        }
        Namespace namespaceAnnotation = cls.getAnnotation(Namespace.class);
        if (namespaceAnnotation != null) {
            return new Namespace[]{namespaceAnnotation};
        }
        return null;
    }

    public static String[] getListAttributeValue(String value) {
        return value.split("\\s+");
    }
}

