/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.infinispan.commands.LocalFlagAffectedCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.distribution.L1NonTxInterceptor;
import org.infinispan.remoting.transport.jgroups.SuspectException;

public class L1TxInterceptor
extends L1NonTxInterceptor {
    @Override
    public CompletableFuture<Void> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.performCommandWithL1WriteIfAble(ctx, command, false, true, true);
    }

    @Override
    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.performCommandWithL1WriteIfAble(ctx, command, false, true, true);
    }

    @Override
    public CompletableFuture<Void> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.performCommandWithL1WriteIfAble(ctx, command, false, true, false);
    }

    @Override
    public CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (command.isOnePhaseCommit() && this.shouldFlushL1(ctx)) {
            this.blockOnL1FutureIfNeeded(this.flushL1Caches(ctx));
        }
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.shouldFlushL1(ctx)) {
            this.blockOnL1FutureIfNeeded(this.flushL1Caches(ctx));
        }
        return ctx.continueInvocation();
    }

    @Override
    protected boolean skipL1Lookup(LocalFlagAffectedCommand command, Object key) {
        return super.skipL1Lookup(command, key);
    }

    private boolean shouldFlushL1(TxInvocationContext ctx) {
        return !ctx.getAffectedKeys().isEmpty();
    }

    private Future<?> flushL1Caches(TxInvocationContext ctx) {
        return this.l1Manager.flushCache(ctx.getAffectedKeys(), ctx.getOrigin(), true);
    }

    private void blockOnL1FutureIfNeeded(Future<?> f) {
        block3: {
            if (f != null && this.cacheConfiguration.transaction().syncCommitPhase()) {
                try {
                    f.get();
                }
                catch (Exception e) {
                    if (e.getCause() instanceof SuspectException) break block3;
                    this.getLog().failedInvalidatingRemoteCache(e);
                }
            }
        }
    }
}

