/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.impl.InterceptorListNode;
import org.infinispan.interceptors.impl.SecurityActions;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.logging.NDC;

public abstract class BaseAsyncInvocationContext
implements InvocationContext {
    private static final Log log = LogFactory.getLog(BaseAsyncInvocationContext.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final boolean EXTRA_LOGS = SecurityActions.getBooleanProperty("org.infinispan.debug.BaseAsyncInvocationContext");
    private static final CompletableFuture<Void> CONTINUE_INVOCATION = CompletableFuture.completedFuture(null);
    private static final int INVOKE_NEXT = 0;
    private static final int SHORT_CIRCUIT = 1;
    private static final int STOP_INVOCATION = 2;
    private static final int FORK_INVOCATION = 3;
    private InterceptorListNode nextInterceptor;
    private ReturnHandlerNode nextReturnHandler;
    private CompletableFuture<Object> future;
    private int action;
    private Object actionValue;

    @Override
    public final CompletableFuture<Void> onReturn(AsyncInterceptor.ReturnHandler returnHandler) {
        this.nextReturnHandler = new ReturnHandlerNode(returnHandler, this.nextReturnHandler);
        return CONTINUE_INVOCATION;
    }

    @Override
    public final CompletableFuture<Void> continueInvocation() {
        return CONTINUE_INVOCATION;
    }

    @Override
    public final CompletableFuture<Void> shortCircuit(Object returnValue) {
        this.preActionCheck();
        this.action = 1;
        this.actionValue = returnValue;
        return CONTINUE_INVOCATION;
    }

    @Override
    public final CompletableFuture<Void> forkInvocation(VisitableCommand newCommand, AsyncInterceptor.ForkReturnHandler forkReturnHandler) {
        this.preActionCheck();
        InterceptorListNode localNode = this.nextInterceptor;
        if (localNode == null) {
            throw new IllegalStateException("Cannot call shortCircuit or forkInvocation after all interceptors have executed");
        }
        this.action = 3;
        ForkInfo forkInfo = new ForkInfo(newCommand, forkReturnHandler);
        forkInfo.savedInterceptor = localNode;
        this.actionValue = forkInfo;
        return CONTINUE_INVOCATION;
    }

    private void preActionCheck() {
        if (this.action != 0) {
            this.throwActionException();
        }
    }

    private void throwActionException() {
        throw new IllegalStateException("An interceptor can call shortCircuit or forkInvocation at most once. The current action is " + BaseAsyncInvocationContext.actionName(this.action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object forkInvocationSync(VisitableCommand newCommand) throws Throwable {
        InterceptorListNode savedInterceptorNode = this.nextInterceptor;
        ReturnHandlerNode savedReturnHandler = this.nextReturnHandler;
        this.nextReturnHandler = null;
        try {
            Object returnValue = this.invokeInterceptorsSync(newCommand, savedInterceptorNode);
            Object object = this.invokeReturnHandlersSync(newCommand, returnValue, null);
            return object;
        }
        catch (Throwable t) {
            Throwable throwable = this.extractCompletableFutureException(t);
            Object object = this.invokeReturnHandlersSync(newCommand, null, throwable);
            return object;
        }
        finally {
            this.action = 0;
            this.nextInterceptor = savedInterceptorNode;
            this.nextReturnHandler = savedReturnHandler;
        }
    }

    private Throwable extractCompletableFutureException(Throwable t) {
        return t instanceof ExecutionException ? t.getCause() : (t instanceof CompletionException ? t.getCause() : t);
    }

    private Object invokeReturnHandlersSync(VisitableCommand command, Object returnValue, Throwable throwable) throws Throwable {
        ReturnHandlerNode returnHandlerNode = this.nextReturnHandler;
        this.nextReturnHandler = null;
        while (returnHandlerNode != null) {
            AsyncInterceptor.ReturnHandler current = returnHandlerNode.returnHandler;
            returnHandlerNode = returnHandlerNode.nextNode;
            try {
                returnValue = this.invokeReturnHandlerSync(current, command, returnValue, throwable);
                throwable = null;
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        if (throwable == null) {
            return returnValue;
        }
        throw throwable;
    }

    final CompletableFuture<Object> invoke(VisitableCommand command, InterceptorListNode firstInterceptor) {
        this.future = new CompletableFuture();
        this.nextInterceptor = firstInterceptor;
        this.nextReturnHandler = null;
        this.action = 0;
        this.invokeNextWithContext(command, null, null);
        return this.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeNextWithContext(VisitableCommand command, Object returnValue, Throwable throwable) {
        Object lockOwner = this.getLockOwner();
        if (lockOwner != null) {
            NDC.push((String)lockOwner.toString());
        }
        try {
            this.invokeNext(command, returnValue, throwable);
        }
        finally {
            NDC.pop();
        }
    }

    private void invokeNext(VisitableCommand command, Object returnValue, Throwable throwable) {
        InterceptorListNode interceptorNode = this.nextInterceptor;
        while (true) {
            if (this.action == 3) {
                ForkInfo forkInfo = (ForkInfo)this.actionValue;
                forkInfo.savedCommand = command;
                command = forkInfo.newCommand;
                this.nextReturnHandler = new ReturnHandlerNode(forkInfo, this.nextReturnHandler);
            } else {
                if (this.action == 2) {
                    this.action = 0;
                    return;
                }
                if (this.action == 1) {
                    returnValue = this.actionValue;
                    interceptorNode = null;
                    this.nextInterceptor = null;
                }
            }
            this.action = 0;
            if (interceptorNode != null) {
                AsyncInterceptor interceptor = interceptorNode.interceptor;
                this.nextInterceptor = interceptorNode = interceptorNode.nextNode;
                if (trace) {
                    log.tracef("Executing interceptor %s with command %s", BaseAsyncInvocationContext.className(interceptor), BaseAsyncInvocationContext.className(command));
                }
                try {
                    CompletableFuture<Void> nextFuture = interceptor.visitCommand(this, command);
                    if (nextFuture.isDone()) {
                        returnValue = nextFuture.getNow(null);
                    }
                    if (EXTRA_LOGS && trace) {
                        log.tracef("Interceptor %s continues asynchronously", interceptor);
                    }
                    VisitableCommand finalCommand = command;
                    nextFuture.whenComplete((rv1, throwable1) -> this.invokeNextWithContext(finalCommand, rv1, (Throwable)throwable1));
                    return;
                }
                catch (Throwable t) {
                    throwable = t;
                    if (t instanceof CompletionException) {
                        throwable = t.getCause();
                    }
                    if (trace) {
                        log.tracef("Interceptor %s threw exception %s", BaseAsyncInvocationContext.className(interceptor), throwable);
                    }
                    this.action = 0;
                    interceptorNode = null;
                    this.nextInterceptor = null;
                }
                continue;
            }
            if (this.nextReturnHandler == null) break;
            AsyncInterceptor.ReturnHandler returnHandler = this.nextReturnHandler.returnHandler;
            this.nextReturnHandler = this.nextReturnHandler.nextNode;
            if (trace) {
                log.tracef("Executing return handler %s with return value/exception %s/%s", new Object[]{this.nextReturnHandler, returnHandler, BaseAsyncInvocationContext.className(returnValue), throwable});
            }
            try {
                CompletableFuture<Object> handlerFuture = returnHandler.handle(this, command, returnValue, throwable);
                if (handlerFuture == null) continue;
                if (handlerFuture.isDone()) {
                    returnValue = handlerFuture.getNow(returnValue);
                    throwable = null;
                    interceptorNode = this.nextInterceptor;
                    continue;
                }
                if (EXTRA_LOGS && trace) {
                    log.tracef("Return handler %s continues asynchronously", returnHandler);
                }
                VisitableCommand finalCommand1 = command;
                handlerFuture.whenComplete((rv1, throwable1) -> this.invokeNextWithContext(finalCommand1, rv1, (Throwable)throwable1));
                return;
            }
            catch (Throwable t) {
                if (trace) {
                    log.tracef("Return handler %s threw exception %s", BaseAsyncInvocationContext.className(returnHandler), t);
                }
                returnValue = null;
                throwable = t;
                interceptorNode = null;
                this.nextInterceptor = null;
                continue;
            }
            break;
        }
        if (EXTRA_LOGS && trace) {
            log.tracef("Command %s done with return value/exception %s/%s", command, BaseAsyncInvocationContext.className(returnValue), throwable);
        }
        BaseAsyncInvocationContext.completeFuture(this.future, returnValue, throwable);
    }

    private CompletableFuture<Object> handleForkReturn(ForkInfo forkInfo, Object returnValue, Throwable throwable) throws Throwable {
        this.nextInterceptor = forkInfo.savedInterceptor;
        CompletableFuture<Object> handlerFuture = forkInfo.forkReturnHandler.handle(this, forkInfo.savedCommand, returnValue, throwable);
        return handlerFuture;
    }

    Object invokeSync(VisitableCommand command, InterceptorListNode firstInterceptor) throws Throwable {
        this.nextReturnHandler = null;
        this.action = 0;
        try {
            Object returnValue = this.invokeInterceptorsSync(command, firstInterceptor);
            return this.invokeReturnHandlersSync(command, returnValue, null);
        }
        catch (Throwable t) {
            Throwable throwable = this.extractCompletableFutureException(t);
            return this.invokeReturnHandlersSync(command, null, throwable);
        }
    }

    private Object invokeInterceptorsSync(VisitableCommand command, InterceptorListNode firstInterceptorNode) throws Throwable {
        InterceptorListNode interceptorNode = firstInterceptorNode;
        AsyncInterceptor interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        CompletableFuture<Void> nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        interceptor = interceptorNode.interceptor;
        interceptorNode = this.beforeVisit(command, interceptorNode, interceptor);
        nextVisitFuture = interceptor.visitCommand(this, command);
        if (this.afterVisit(command, nextVisitFuture)) {
            return this.actionValue;
        }
        if (interceptorNode != null) {
            throw new IllegalStateException("Too many interceptors!");
        }
        throw new IllegalStateException("CallInterceptor must call shortCircuit");
    }

    private InterceptorListNode beforeVisit(VisitableCommand command, InterceptorListNode interceptorNode, AsyncInterceptor interceptor) {
        this.nextInterceptor = interceptorNode = interceptorNode.nextNode;
        if (trace) {
            log.tracef("Invoking interceptor %s with command %s", BaseAsyncInvocationContext.className(interceptor), BaseAsyncInvocationContext.className(command));
        }
        return interceptorNode;
    }

    private boolean afterVisit(VisitableCommand command, CompletableFuture<Void> nextVisitFuture) throws Throwable {
        if (nextVisitFuture != CONTINUE_INVOCATION) {
            CompletableFutures.await(nextVisitFuture);
        }
        while (this.action == 3) {
            this.invokeForkAndHandlerSync(command);
        }
        return this.action == 1;
    }

    private void invokeForkAndHandlerSync(VisitableCommand command) throws Throwable {
        this.action = 0;
        ForkInfo forkInfo = (ForkInfo)this.actionValue;
        Object forkReturnValue = null;
        Throwable throwable = null;
        try {
            forkReturnValue = this.forkInvocationSync(forkInfo.newCommand);
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (trace) {
            log.tracef("Invoking fork return handler %s with return value/exception: %s/%s", BaseAsyncInvocationContext.className(forkInfo.forkReturnHandler), BaseAsyncInvocationContext.className(forkReturnValue), BaseAsyncInvocationContext.className(throwable));
        }
        CompletableFuture<Void> handlerFuture = forkInfo.forkReturnHandler.handle(this, command, forkReturnValue, throwable);
        CompletableFutures.await(handlerFuture);
    }

    private Object invokeReturnHandlerSync(AsyncInterceptor.ReturnHandler returnHandler, VisitableCommand command, Object returnValue, Throwable throwable) throws Throwable {
        CompletableFuture<Object> handlerFuture;
        if (trace) {
            log.tracef("Invoking return handler %s with return value/exception: %s/%s", BaseAsyncInvocationContext.className(returnHandler), BaseAsyncInvocationContext.className(returnValue), BaseAsyncInvocationContext.className(throwable));
        }
        if ((handlerFuture = returnHandler.handle(this, command, returnValue, throwable)) != null) {
            return CompletableFutures.await(handlerFuture);
        }
        if (throwable != null) {
            throw throwable;
        }
        return returnValue;
    }

    private static <T, E extends Throwable> void completeFuture(CompletableFuture<T> future, T returnValue, E exception) {
        if (exception == null) {
            future.complete(returnValue);
        } else {
            future.completeExceptionally(exception);
        }
    }

    private static String className(Object o) {
        if (o == null) {
            return "null";
        }
        String fullName = o.getClass().getName();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    private static String actionName(int action) {
        switch (action) {
            case 0: {
                return "INVOKE_NEXT";
            }
            case 1: {
                return "SHORT_CIRCUIT";
            }
            case 2: {
                return "STOP_INVOCATION";
            }
            case 3: {
                return "FORK_INVOCATION";
            }
        }
        return "Unknown action " + action;
    }

    @Override
    public InvocationContext clone() {
        try {
            BaseAsyncInvocationContext clone = (BaseAsyncInvocationContext)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException("Impossible", (Throwable)e);
        }
    }

    private static class ReturnHandlerNode {
        final AsyncInterceptor.ReturnHandler returnHandler;
        final ReturnHandlerNode nextNode;

        ReturnHandlerNode(AsyncInterceptor.ReturnHandler returnHandler, ReturnHandlerNode next) {
            this.returnHandler = returnHandler;
            this.nextNode = next;
        }
    }

    private static class ForkInfo
    implements AsyncInterceptor.ReturnHandler {
        final VisitableCommand newCommand;
        final AsyncInterceptor.ForkReturnHandler forkReturnHandler;
        InterceptorListNode savedInterceptor;
        VisitableCommand savedCommand;

        ForkInfo(VisitableCommand newCommand, AsyncInterceptor.ForkReturnHandler forkReturnHandler) {
            this.newCommand = newCommand;
            this.forkReturnHandler = forkReturnHandler;
        }

        public String toString() {
            return "ForkInfo{" + this.newCommand.getClass().getSimpleName() + "}";
        }

        @Override
        public CompletableFuture<Object> handle(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable throwable) throws Throwable {
            return ((BaseAsyncInvocationContext)rCtx).handleForkReturn(this, rv, throwable);
        }
    }
}

