/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.interceptors.xsite.BaseBackupInterceptor;

public class NonTransactionalBackupInterceptor
extends BaseBackupInterceptor {
    private CommandsFactory commandsFactory;
    private ClusteringDependentLogic clusteringDependentLogic;

    @Inject
    public void injectDependencies(CommandsFactory commandsFactory, ClusteringDependentLogic clusteringDependentLogic) {
        this.commandsFactory = commandsFactory;
        this.clusteringDependentLogic = clusteringDependentLogic;
    }

    @Override
    public CompletableFuture<Void> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleMultipleKeysWriteCommand(ctx, command);
    }

    private CompletableFuture<Void> handleSingleKeyWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        return ctx.onReturn((rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                throw throwable;
            }
            DataWriteCommand dataWriteCommand = (DataWriteCommand)rCommand;
            if (!this.skipXSiteBackup(dataWriteCommand) && dataWriteCommand.isSuccessful() && this.clusteringDependentLogic.localNodeIsPrimaryOwner(dataWriteCommand.getKey())) {
                this.backupSender.processResponses(this.backupSender.backupWrite(this.transform(dataWriteCommand)), dataWriteCommand);
            }
            return null;
        });
    }

    private WriteCommand transform(DataWriteCommand command) {
        if (command instanceof PutKeyValueCommand) {
            PutKeyValueCommand putCommand = (PutKeyValueCommand)command;
            return this.commandsFactory.buildPutKeyValueCommand(putCommand.getKey(), putCommand.getValue(), command.getMetadata(), command.getFlagsBitSet());
        }
        if (command instanceof ReplaceCommand) {
            ReplaceCommand replaceCommand = (ReplaceCommand)command;
            return this.commandsFactory.buildPutKeyValueCommand(replaceCommand.getKey(), replaceCommand.getNewValue(), command.getMetadata(), command.getFlagsBitSet());
        }
        if (command instanceof RemoveCommand) {
            return this.commandsFactory.buildRemoveCommand(command.getKey(), null, command.getFlagsBitSet());
        }
        throw new IllegalArgumentException("Command " + command + " is not valid!");
    }
}

